/*
 * Decompiled with CFR 0.152.
 */
package com.raonsecure.touchen_mguard_4_0.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.FileProvider;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Util {
    public static boolean isInstalledApp(Context ctx, String strPackageName) {
        Intent isInstallPackage = ctx.getPackageManager().getLaunchIntentForPackage(strPackageName);
        return isInstallPackage != null;
    }

    public static int isRooting() {
        String[] rootingFiles;
        for (String path : rootingFiles = new String[]{"/system/xbin/su", "/system/bin/su", "/system/app/superuser.apk", "/data/data/com.noshufou.android.su"}) {
            File f = new File(path);
            if (!f.exists()) continue;
            return -10;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File input, File output) {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int temp;
            in = new BufferedInputStream(new FileInputStream(input));
            out = new BufferedOutputStream(new FileOutputStream(output));
            while ((temp = in.read()) != -1) {
                out.write(temp);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public static void installAPK(Context context, String fileName) {
        Util.installAPK(context, fileName, null);
    }

    public static void installAPK(Context context, String fileName, String authoritiesFileProvider) {
        Uri apkUri;
        File apkFile = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + fileName + ".apk");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        int targetSdkVersion = Util.getTargetSdkVersion(context);
        if (targetSdkVersion >= 24 && Build.VERSION.SDK_INT >= 24) {
            if (authoritiesFileProvider == null || authoritiesFileProvider.length() < 1) {
                authoritiesFileProvider = context.getPackageName() + ".provider.MGuardSdkFileProvider";
            }
            apkUri = FileProvider.getUriForFile((Context)context.getApplicationContext(), (String)authoritiesFileProvider, (File)apkFile);
            intent.addFlags(1);
        } else {
            apkUri = Uri.fromFile((File)apkFile);
        }
        intent.setDataAndType(apkUri, "application/vnd.android.package-archive");
        context.startActivity(intent);
    }

    public static boolean checkParams(Object ... objects) {
        int index = 0;
        for (Object obj : objects) {
            if (obj == null) {
                Log.e((String)"mGuardSDK", (String)(Util.getCallerInfo() + ", parameter {index:" + index + "} is null."));
                return false;
            }
            ++index;
        }
        return true;
    }

    public static String getCallerInfo() {
        int depth = 2;
        String callerInfo = "";
        StackTraceElement[] elements = new Throwable().fillInStackTrace().getStackTrace();
        if (elements != null && elements.length > depth) {
            StackTraceElement el = elements[depth];
            String className = el.getClassName();
            className = className.substring(className.lastIndexOf(46) + 1);
            callerInfo = className + "." + el.getMethodName() + "():" + el.getLineNumber();
        }
        return callerInfo;
    }

    public static int getTargetSdkVersion(Context context) {
        return context.getApplicationContext().getApplicationInfo().targetSdkVersion;
    }
}

