/*
 * Decompiled with CFR 0.152.
 */
package com.raonsecure.touchen_mguard_4_0;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.raonsecure.touchen_mguard_4_0.MDMAPI;
import com.raonsecure.touchen_mguard_4_0.remote.aidl.IMdmMonitor;
import com.raonsecure.touchen_mguard_4_0.remote.aidl.IMdmMonitorListener;
import java.util.List;

public class RemoteMDMServiceConn
implements ServiceConnection {
    private static final String TAG = RemoteMDMServiceConn.class.getSimpleName();
    IMdmMonitor imm = null;
    private MDMAPI.MGuardConnectionListener connectListener;

    public RemoteMDMServiceConn(MDMAPI.MGuardConnectionListener listener) {
        this.connectListener = listener;
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.imm = IMdmMonitor.Stub.asInterface(service);
        Log.d((String)TAG, (String)"onServiceConnected...");
        if (this.connectListener != null) {
            this.connectListener.onComplete(0);
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        Log.d((String)TAG, (String)"onServiceDisconnected...");
        if (this.connectListener != null) {
            this.connectListener.onComplete(-1);
        }
    }

    protected int getLoginStat() {
        int logInState = -1;
        try {
            logInState = this.imm != null ? this.imm.isLogin() : -2;
        }
        catch (Exception e) {
            e.printStackTrace();
            logInState = -1;
        }
        Log.d((String)TAG, (String)("logInState: " + logInState));
        return logInState;
    }

    protected void officeBlock(String packageName, int bitFlag, final MDMAPI.MGuardCallbackListener listener) {
        try {
            if (this.imm != null) {
                this.imm.officeBlock(packageName, bitFlag, new IMdmMonitorListener.Stub(){

                    @Override
                    public void callBackCompleted(int result, final String info) throws RemoteException {
                        final int error = result;
                        if (listener != null) {
                            Handler handler = new Handler(Looper.getMainLooper());
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(error, info);
                                }
                            });
                        }
                    }
                });
            } else {
                listener.onCompleted(-2, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.onCompleted(-1, "");
        }
    }

    protected void officeLoginCheck(List<String> OfficeLoginCheck, final MDMAPI.MGuardCallbackListener listener) {
        try {
            if (this.imm != null) {
                this.imm.officeLoginCheck(OfficeLoginCheck, new IMdmMonitorListener.Stub(){

                    @Override
                    public void callBackCompleted(int result, final String info) throws RemoteException {
                        final int error = result;
                        if (listener != null) {
                            Handler handler = new Handler(Looper.getMainLooper());
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(error, info);
                                }
                            });
                        }
                    }
                });
            } else {
                listener.onCompleted(-2, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.onCompleted(-1, "");
        }
    }

    protected void officeLogin(String packageName, final MDMAPI.MGuardCallbackListener listener) {
        try {
            if (this.imm != null) {
                this.imm.officeLogin(packageName, new IMdmMonitorListener.Stub(){

                    @Override
                    public void callBackCompleted(int result, final String info) throws RemoteException {
                        final int error = result;
                        if (listener != null) {
                            Handler handler = new Handler(Looper.getMainLooper());
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(error, info);
                                }
                            });
                        }
                    }
                });
            } else {
                listener.onCompleted(-2, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.onCompleted(-1, "");
        }
    }

    protected void officeLogout(String packageName, final MDMAPI.MGuardCallbackListener listener) {
        try {
            if (this.imm != null) {
                this.imm.officeLogout(packageName, new IMdmMonitorListener.Stub(){

                    @Override
                    public void callBackCompleted(int result, final String info) throws RemoteException {
                        final int error = result;
                        if (listener != null) {
                            Handler handler = new Handler(Looper.getMainLooper());
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(error, info);
                                }
                            });
                        }
                    }
                });
            } else {
                listener.onCompleted(-2, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.onCompleted(-1, "");
        }
    }

    protected int isRooting() {
        int result = -1;
        try {
            if (this.imm == null) {
                return -2;
            }
            result = this.imm.isRooting();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return result;
    }

    protected void getDeviceUserInfo(final MDMAPI.MGuardCallbackListener listener) {
        try {
            if (this.imm != null) {
                this.imm.getDeviceUserInfo(new IMdmMonitorListener.Stub(){

                    @Override
                    public void callBackCompleted(int result, final String info) throws RemoteException {
                        final int error = result;
                        if (listener != null) {
                            Handler handler = new Handler(Looper.getMainLooper());
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(error, info);
                                }
                            });
                        }
                    }
                });
            } else {
                listener.onCompleted(-2, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.onCompleted(-1, "");
        }
    }

    protected void checkAgent(final MDMAPI.MGuardCallbackListener listener) {
        try {
            if (this.imm != null) {
                this.imm.checkAgent(new IMdmMonitorListener.Stub(){

                    @Override
                    public void callBackCompleted(int result, final String info) throws RemoteException {
                        final int error = result;
                        if (listener != null) {
                            Handler handler = new Handler(Looper.getMainLooper());
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(error, info);
                                }
                            });
                        }
                    }
                });
            } else {
                listener.onCompleted(-2, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.onCompleted(-2, "");
        }
    }

    protected int loginDirectly(String id, String pw, final MDMAPI.MGuardCallbackListener listener) {
        int result = 0;
        try {
            if (this.imm == null) {
                return -2;
            }
            result = this.imm.loginDirectly(id, pw, new IMdmMonitorListener.Stub(){

                @Override
                public void callBackCompleted(int result, final String info) throws RemoteException {
                    final int error = result;
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onCompleted(error, info);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return result;
    }

    protected int officeSendData(String packageName, String dataType, String data, String callApp, final MDMAPI.MGuardCallbackListener listener) {
        int result = 0;
        try {
            if (this.imm == null) {
                return -2;
            }
            result = this.imm.sendOfficeData(packageName, dataType, data, callApp, new IMdmMonitorListener.Stub(){

                @Override
                public void callBackCompleted(int result, final String info) throws RemoteException {
                    final int error = result;
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onCompleted(error, info);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return result;
    }

    protected int getFidoPattern(String pkg, final String officeCode, final MDMAPI.MGuardCallbackListener listener) {
        int result = 0;
        try {
            if (this.imm == null) {
                return -2;
            }
            result = this.imm.getFidoPattern(pkg, officeCode, new IMdmMonitorListener.Stub(){

                @Override
                public void callBackCompleted(final int result, final String info) throws RemoteException {
                    final int error = result;
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            Log.d((String)TAG, (String)("getFidoPattern result :" + result));
                            Log.d((String)TAG, (String)("getFidoPattern info :" + info));
                            String[] infos = info.split(",");
                            int code = Integer.parseInt(infos[0]);
                            MDMAPI.getInstance().setPatternCode(code);
                            MDMAPI.getInstance().setOfficeCode(officeCode);
                            listener.onCompleted(error, info);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return result;
    }

    protected int getFidoAuthResult(String userId, String pkgName, String officeCode, final MDMAPI.MGuardCallbackListener listener) {
        int result = 0;
        try {
            if (this.imm != null) {
                if (!MDMAPI.getInstance().getOfficeCode().equals(officeCode)) {
                    MDMAPI.getInstance().setPatternCode(-1);
                }
            } else {
                return -2;
            }
            result = this.imm.getFidoAuthResult(userId, pkgName, officeCode, MDMAPI.getInstance().getPatternCode(), new IMdmMonitorListener.Stub(){

                @Override
                public void callBackCompleted(final int result, final String info) throws RemoteException {
                    final int error = result;
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            Log.d((String)"djpark", (String)("getFidoAuthResult result :" + result));
                            Log.d((String)"djpark", (String)("getFidoAuthResult info :" + info));
                            MDMAPI.getInstance().setPatternCode(-1);
                            listener.onCompleted(error, info);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return result;
    }

    protected int goFidoRegister(final MDMAPI.MGuardCallbackListener listener) {
        int result = 0;
        try {
            if (this.imm != null) {
                result = this.imm.goFidoRegisterActivity(new IMdmMonitorListener.Stub(){

                    @Override
                    public void callBackCompleted(int result, final String info) throws RemoteException {
                        final int error = result;
                        Handler handler = new Handler(Looper.getMainLooper());
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onCompleted(error, info);
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return result;
    }

    protected int getOtpConfig(final MDMAPI.MGuardCallbackListener listener) {
        int result = 0;
        try {
            if (this.imm != null) {
                result = this.imm.getOtpValue(new IMdmMonitorListener.Stub(){

                    @Override
                    public void callBackCompleted(int result, final String info) throws RemoteException {
                        final int error = result;
                        Handler handler = new Handler(Looper.getMainLooper());
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onCompleted(error, info);
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return result;
    }

    public boolean isConnected() {
        return this.imm != null;
    }

    protected void officeAuth(String servTrId, String trId, String serviceId, String userId, final MDMAPI.MGuardCallbackListener listener) {
        try {
            if (this.imm != null) {
                this.imm.officeAuth(servTrId, trId, serviceId, userId, new IMdmMonitorListener.Stub(){

                    @Override
                    public void callBackCompleted(int result, final String detailErrCode) throws RemoteException {
                        final int error = result;
                        if (listener != null) {
                            Handler handler = new Handler(Looper.getMainLooper());
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(error, detailErrCode);
                                }
                            });
                        }
                    }
                });
            } else {
                listener.onCompleted(-2, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.onCompleted(-1, "");
        }
    }

    protected int getSGVPNStatus(final MDMAPI.MGuardCallbackListener listener) {
        int vpnStatus = -1;
        try {
            if (this.imm == null) {
                return -2;
            }
            vpnStatus = this.imm.getSGVPNStatus(new IMdmMonitorListener.Stub(){

                @Override
                public void callBackCompleted(int result, final String info) throws RemoteException {
                    final int error = result;
                    if (listener != null) {
                        Handler handler = new Handler(Looper.getMainLooper());
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onCompleted(error, info);
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return vpnStatus;
    }
}

