/*
 * Decompiled with CFR 0.152.
 */
package com.raonsecure.touchen_mguard_4_0;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Environment;
import android.os.Looper;
import android.util.Log;
import com.raonsecure.touchen_mguard_4_0.RemoteMDMServiceConn;
import com.raonsecure.touchen_mguard_4_0.utils.DownloadProcessor;
import com.raonsecure.touchen_mguard_4_0.utils.FileDownloadProgressDialog;
import com.raonsecure.touchen_mguard_4_0.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public class MDMAPI {
    private static final String TAG = MDMAPI.class.getSimpleName();
    public static final String API_VER = "1.1.17";
    public static final int FLAG_POLICY_BLOCK_WIFI = 1;
    public static final int FLAG_POLICY_BLOCK_3GDATA = 2;
    public static final int FLAG_POLICY_BLOCK_BLUETOOTH = 4;
    public static final int FLAG_POLICY_BLOCK_OUTBOUND_CALL = 8;
    public static final int FLAG_POLICY_BLOCK_TETHERING = 16;
    public static final int FLAG_POLICY_BLOCK_BROWSER = 32;
    public static final int FLAG_POLICY_BLOCK_CAMERA = 64;
    public static final int FLAG_POLICY_BLOCK_DETECT_USB = 128;
    public static final int FLAG_POLICY_DELETE_PREVENTION = 256;
    public static final int FLAG_POLICY_BLOCK_RECORD = 512;
    public static final int FLAG_POLICY_BLOCK_CAPTURE = 1024;
    public static final int FLAG_POLICY_BLOCK_APP_STORE = 2048;
    public static final int FLAG_POLICY_BLOCK_MOBILE_AP = 4096;
    private String SERVER_URL = null;
    private String AGENT_DOWNLOAD_API = "/all/files/androidDownloadAgent.do";
    private static String MGUARD_PACKAGE_NAME = "com.raonsecure.touchen_mguard_4_0";
    private final String ACTION_REMOTE_SERVICE = "com.raonsecure.touchen_mguard_4_0.RemoteMDMService";
    @Deprecated
    private Context _mContext;
    @Deprecated
    private Activity _mActivity;
    private RemoteMDMServiceConn _MDMLibService;
    private static volatile MDMAPI sharedInstance;
    private String callerPackageName;
    private String authoritiesFileProvider;
    private int patternCode = -1;
    private String officeCode = "0000";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    public static MDMAPI getInstance(Context context, Activity activity) {
        if (sharedInstance == null) {
            Class<MDMAPI> clazz = MDMAPI.class;
            // MONITORENTER : com.raonsecure.touchen_mguard_4_0.MDMAPI.class
            sharedInstance = new MDMAPI();
            // MONITOREXIT : clazz
        }
        MDMAPI.sharedInstance._mContext = context;
        MDMAPI.sharedInstance._mActivity = activity;
        return sharedInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MDMAPI getInstance() {
        if (sharedInstance != null) return sharedInstance;
        Class<MDMAPI> clazz = MDMAPI.class;
        synchronized (MDMAPI.class) {
            sharedInstance = new MDMAPI();
            sharedInstance.setPatternCode(-1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharedInstance;
        }
    }

    private MDMAPI() {
        Log.i((String)TAG, (String)("mGuardSDK version : " + this.RS_MDM_getVersion()));
    }

    @Deprecated
    public void RS_MDM_Init(String serverURL, MGuardConnectionListener listener) {
        this.RS_MDM_Init(this._mContext, serverURL, listener);
    }

    public void RS_MDM_Init(Context context, String serverURL, MGuardConnectionListener listener) {
        this.RS_MDM_Init(context, serverURL, listener, null);
    }

    public void RS_MDM_Init(Context context, String serverURL, MGuardConnectionListener listener, String packageNameOneGuard) {
        if (!Util.checkParams(context, serverURL, listener)) {
            return;
        }
        if (packageNameOneGuard != null && packageNameOneGuard.length() > 0) {
            MGUARD_PACKAGE_NAME = packageNameOneGuard;
        }
        this.callerPackageName = context.getPackageName();
        if (this._MDMLibService != null) {
            this.RS_MDM_Release(context);
        }
        this._MDMLibService = new RemoteMDMServiceConn(listener);
        Log.d((String)TAG, (String)"MDMAPI init alloc RemoteMDMServiceConn");
        this.SERVER_URL = serverURL;
        Log.d((String)TAG, (String)("MDMAPI RS_MDM_Init:: serverUrl: " + this.SERVER_URL));
        if (!Util.isInstalledApp(context, MGUARD_PACKAGE_NAME)) {
            listener.onComplete(-100);
            return;
        }
        try {
            Intent intent = new Intent().setAction("com.raonsecure.touchen_mguard_4_0.RemoteMDMService");
            intent.setPackage(MGUARD_PACKAGE_NAME);
            context.bindService(intent, (ServiceConnection)this._MDMLibService, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.onComplete(-1);
        }
    }

    @Deprecated
    public void RS_MDM_Init(String serverURL, String authoritiesFileProvider, MGuardConnectionListener listener) {
        this.RS_MDM_Init(this._mContext, serverURL, authoritiesFileProvider, listener);
    }

    public void RS_MDM_Init(Context context, String serverURL, String authoritiesFileProvider, MGuardConnectionListener listener) {
        this.RS_MDM_Init(context, serverURL, listener, null);
        this.authoritiesFileProvider = authoritiesFileProvider;
    }

    public void RS_MDM_Init(Context context, String serverURL, String authoritiesFileProvider, MGuardConnectionListener listener, String packageNameOneGuard) {
        this.RS_MDM_Init(context, serverURL, listener, packageNameOneGuard);
        this.authoritiesFileProvider = authoritiesFileProvider;
    }

    public void RS_MDM_Release(Context context) {
        if (!Util.checkParams(context)) {
            return;
        }
        if (this._MDMLibService != null) {
            if (this._MDMLibService.isConnected()) {
                try {
                    context.unbindService((ServiceConnection)this._MDMLibService);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)e.getMessage());
                }
            }
            this._MDMLibService = null;
        }
    }

    @Deprecated
    public void RS_MDM_CheckAgent(MGuardCallbackListener listener) {
        this.RS_MDM_CheckAgent(this._mContext, listener);
    }

    public void RS_MDM_CheckAgent(Context context, MGuardCallbackListener listener) {
        if (!Util.checkParams(context, listener)) {
            return;
        }
        if (this._MDMLibService != null) {
            boolean isInstalledApp = Util.isInstalledApp(context, MGUARD_PACKAGE_NAME);
            Log.d((String)TAG, (String)("RS_MDM_CheckList:: MDM \uc124\uce58\uc720\ubb34 \uccb4\ud06c: " + isInstalledApp));
            if (!isInstalledApp) {
                listener.onCompleted(-100, "");
                return;
            }
            int checkResult = this._MDMLibService.getLoginStat();
            Log.d((String)TAG, (String)("RS_MDM_CheckList:: \ub85c\uadf8\uc778 \uc720\ubb34 \uccb4\ud06c: " + checkResult));
            if (checkResult != 0) {
                listener.onCompleted(-101, "");
                return;
            }
            checkResult = this._MDMLibService.isRooting();
            Log.d((String)TAG, (String)("RS_MDM_CheckList:: MDM \ub8e8\ud305\uc720\ubb34 \uccb4\ud06c: " + checkResult));
            if (checkResult == -10) {
                listener.onCompleted(-10, "");
                return;
            }
            this._MDMLibService.checkAgent(listener);
        } else {
            listener.onCompleted(-10000, "");
        }
    }

    public void RS_MDM_GetDeviceUserInfo(MGuardCallbackListener listener) {
        if (!Util.checkParams(listener)) {
            return;
        }
        if (this._MDMLibService != null) {
            this._MDMLibService.getDeviceUserInfo(listener);
        } else {
            listener.onCompleted(-10000, "");
        }
    }

    public void RS_MDM_LoginOfficeCheck(Map<String, String> OfficeLoginCheck, MGuardCallbackListener listener) {
        if (!Util.checkParams(OfficeLoginCheck, listener)) {
            return;
        }
        if (this._MDMLibService != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry<String, String> entry : OfficeLoginCheck.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                list.add(key + "|" + value);
            }
            list.add("packageName|" + this.callerPackageName);
            this._MDMLibService.officeLoginCheck(list, listener);
        } else {
            listener.onCompleted(-10000, "");
        }
    }

    public void RS_MDM_LoginOffice(MGuardCallbackListener listener) {
        if (!Util.checkParams(listener)) {
            return;
        }
        if (this._MDMLibService != null) {
            this._MDMLibService.officeLogin(this.callerPackageName, listener);
        } else {
            listener.onCompleted(-10000, "");
        }
    }

    public void RS_MDM_LogoutOffice(MGuardCallbackListener listener) {
        if (!Util.checkParams(listener)) {
            return;
        }
        if (this._MDMLibService != null) {
            this._MDMLibService.officeLogout(this.callerPackageName, listener);
        } else {
            listener.onCompleted(-10000, "");
        }
    }

    @Deprecated
    public void RS_MDM_InstallAgent(FileDownloadProgressListener listener) {
        this.RS_MDM_InstallAgent(this._mActivity, listener);
    }

    public void RS_MDM_InstallAgent(Activity activity, FileDownloadProgressListener listener) {
        if (!Util.checkParams(activity, listener)) {
            return;
        }
        if (this._MDMLibService != null) {
            this.downloadAgent(activity, listener);
        } else {
            listener.onFailed();
        }
    }

    public void RS_MDM_HwContrl(int bitFlag, MGuardCallbackListener listener) {
        if (!Util.checkParams(bitFlag, listener)) {
            return;
        }
        boolean result = false;
        if (this._MDMLibService != null) {
            this._MDMLibService.officeBlock(this.callerPackageName, bitFlag, listener);
        } else {
            listener.onCompleted(-10000, "");
        }
    }

    public int RS_MDM_LoginDirectly(String id, String pw, MGuardCallbackListener listener) {
        if (!Util.checkParams(id, pw, listener)) {
            return -1;
        }
        if (this._MDMLibService != null) {
            return this._MDMLibService.loginDirectly(id, pw, listener);
        }
        return -10000;
    }

    @Deprecated
    public int RS_MDM_GOMDMLogin() {
        return this.RS_MDM_GOMDMLogin(this._mContext);
    }

    public int RS_MDM_GOMDMLogin(Context context) {
        if (!Util.checkParams(context)) {
            return -1;
        }
        if (this._MDMLibService != null) {
            Intent LaunchIntent = context.getPackageManager().getLaunchIntentForPackage(MGUARD_PACKAGE_NAME);
            context.startActivity(LaunchIntent);
        }
        return -10000;
    }

    public int RS_MDM_SendDataOffice(String packageName, String dataType, String data, String callApp, MGuardCallbackListener listener) {
        if (this._MDMLibService != null) {
            return this._MDMLibService.officeSendData(packageName, dataType, data, callApp, listener);
        }
        return -10000;
    }

    public int RS_MDM_CheckPermission() {
        boolean result = false;
        if (this._MDMLibService != null) {
            return this._MDMLibService.getLoginStat();
        }
        return -10000;
    }

    public int RS_MDM_DeleteAgent() {
        if (this._MDMLibService != null) {
            // empty if block
        }
        return -10000;
    }

    public int RS_MDM_DirectlyLogin(String flag) {
        if (this._MDMLibService != null) {
            // empty if block
        }
        return -10000;
    }

    public int RS_MDM_CheckMobileOffice(String flag) {
        if (this._MDMLibService != null) {
            // empty if block
        }
        return -10000;
    }

    public int RS_MDM_CheckVaccine() {
        if (this._MDMLibService != null) {
            // empty if block
        }
        return -10000;
    }

    int getPatternCode() {
        return this.patternCode;
    }

    void setPatternCode(int patternCode) {
        this.patternCode = patternCode;
    }

    String getOfficeCode() {
        return this.officeCode;
    }

    void setOfficeCode(String officeCode) {
        this.officeCode = officeCode;
    }

    private void downloadAgent(final Activity activity, final FileDownloadProgressListener fileDownloadCallbackListener) {
        Log.i((String)TAG, (String)"downloadWebLink");
        String[] sourceUrls = new String[]{this.SERVER_URL + this.AGENT_DOWNLOAD_API};
        String[] destFiles = new String[]{Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "mGuard.apk"};
        DownloadProcessor.DownloadHandler downloadHandler = new DownloadProcessor.DownloadHandler(Looper.getMainLooper()){

            @Override
            public void sendFinished() {
                Log.i((String)TAG, (String)"sendFinished");
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.toString();
                }
                Util.installAPK((Context)activity, "mGuard", MDMAPI.this.authoritiesFileProvider);
                if (fileDownloadCallbackListener != null) {
                    fileDownloadCallbackListener.onCompleted();
                }
            }

            @Override
            public void sendError(String errmsg) {
                Log.i((String)TAG, (String)"sendError");
                if (fileDownloadCallbackListener != null) {
                    fileDownloadCallbackListener.onFailed();
                }
            }

            @Override
            public void sendAborted() {
                Log.i((String)TAG, (String)"sendAborted");
                if (fileDownloadCallbackListener != null) {
                    fileDownloadCallbackListener.onFailed();
                }
            }
        };
        FileDownloadProgressDialog fileDownloadManager = new FileDownloadProgressDialog(activity, downloadHandler);
        fileDownloadManager.download(1, sourceUrls, destFiles, true);
    }

    public void RS_MDM_GetFidoPattern(String officeCode, MGuardCallbackListener listener) {
        if (!Util.checkParams(this.callerPackageName, listener)) {
            return;
        }
        int patternResult = 0;
        if (this._MDMLibService != null) {
            patternResult = this._MDMLibService.getFidoPattern(this.callerPackageName, officeCode, listener);
        }
        Log.d((String)TAG, (String)("Fido Init Result : " + patternResult));
    }

    public void RS_MDM_FidoAuth(String userId, String officeCode, MGuardCallbackListener listener) {
        if (userId == null) {
            userId = "";
        }
        if (!Util.checkParams(userId, this.callerPackageName, listener)) {
            return;
        }
        int fidoAuthResult = -1;
        if (this._MDMLibService != null) {
            fidoAuthResult = this._MDMLibService.getFidoAuthResult(userId, this.callerPackageName, officeCode, listener);
        }
        Log.d((String)TAG, (String)("Fido Auth Result : " + fidoAuthResult));
    }

    @Deprecated
    public void RS_MDM_FidoGoRegister(MGuardCallbackListener listener) {
        if (!Util.checkParams(listener)) {
            return;
        }
        if (this._MDMLibService != null) {
            int loginState = this._MDMLibService.getLoginStat();
            Log.d((String)TAG, (String)("RS_MDM_FidoGoRegister:: \ub85c\uadf8\uc778 \uc720\ubb34 \uccb4\ud06c: " + loginState));
            if (loginState != 0) {
                listener.onCompleted(-101, "\ub85c\uadf8\uc778 \ub418\uc5b4 \uc788\uc9c0 \uc54a\uc74c");
                return;
            }
            this._MDMLibService.goFidoRegister(listener);
        }
    }

    public String RS_MDM_getVersion() {
        return API_VER;
    }

    public void RS_MDM_GetOtpValue(MGuardCallbackListener listener) {
        if (!Util.checkParams(listener)) {
            return;
        }
        if (this._MDMLibService != null) {
            this._MDMLibService.getOtpConfig(listener);
        }
    }

    public void RS_MDM_AuthOffice(String servTrId, String trId, String servId, String userId, MGuardCallbackListener listener) {
        if (this._MDMLibService != null) {
            this._MDMLibService.officeAuth(servTrId, trId, servId, userId, listener);
        } else {
            listener.onCompleted(-10000, "");
        }
    }

    public int RS_MDM_GetVPNStatus(MGuardCallbackListener listener) {
        if (!Util.checkParams(listener)) {
            return -1;
        }
        if (this._MDMLibService != null) {
            return this._MDMLibService.getSGVPNStatus(listener);
        }
        return -10000;
    }

    public static interface FileDownloadProgressListener {
        public void onCompleted();

        public void onFailed();
    }

    public static interface MGuardCallbackListener {
        public void onCompleted(int var1, String var2);
    }

    public static interface MGuardConnectionListener {
        public void onComplete(int var1);
    }
}

