/*
 * Decompiled with CFR 0.152.
 */
package com.lumensoft.ks;

import com.lumensoft.ks.KSException;
import com.lumensoft.ks.KSSeed;
import com.lumensoft.ks.KSTranslator;
import com.lumensoft.ks.n;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class KSUtil {
    public static final String ver = "1.6.9";
    public static final int TYPE_LANGUAGE_KR = 1;
    public static final int TYPE_LANGUAGE_US = 2;
    private static KSTranslator a = null;
    private static final byte[] a = new byte[]{84, 92, 113, 110, 125, 122, 87, -126, -54, -93, -100, 75, 108, 120, -88, 71};

    public static void setLanguage(int n2) {
        if (n2 == 1) {
            KSUtil.setTranslator(KSTranslator.KOREAN);
        }
        if (n2 == 2) {
            KSUtil.setTranslator(KSTranslator.ENGLISH);
        }
    }

    public static void setTranslator(KSTranslator kSTranslator) {
        a = kSTranslator;
    }

    public static KSTranslator getTranslator() {
        if (a == null) {
            a = KSTranslator.KOREAN;
        }
        return a;
    }

    public static void saveFile(String string, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string, true);
        fileOutputStream.write(byArray);
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    public static void saveFileAppend(String string, byte[] byArray, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
        fileOutputStream.write(byArray);
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    public static void saveFile(String string, byte[] byArray, int n2, int n3) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string, true);
        fileOutputStream.write(byArray, n2, n3);
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    public static byte[] readFile(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("invalid path");
        }
        FileInputStream fileInputStream = null;
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("no exist keyfile");
        }
        int n2 = (int)file.length();
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        fileInputStream = new FileInputStream(string);
        fileInputStream.read(byArray);
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        return byArray;
    }

    public static int getTimeNum(byte[] byArray) {
        int[] nArray = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        int n2 = (byArray[0] - 48) * 10 + byArray[1] - 48;
        int n3 = (byArray[2] - 48) * 10 + byArray[3] - 48;
        int n4 = (byArray[4] - 48) * 10 + byArray[5] - 48;
        int n5 = n2 * 365 + nArray[n3 - 1] + n4;
        return n5 += n3 > 2 ? n2 / 4 + 1 : n2 / 4;
    }

    public static byte[] encryptSeed(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = null;
        int n2 = byArray.length;
        int n3 = 16 - n2 % 16;
        byte[] byArray5 = new byte[n2 + n3];
        System.arraycopy(byArray, 0, byArray5, 0, n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray5[n2 + i2] = (byte)n3;
        }
        try {
            KSSeed kSSeed = new KSSeed();
            byArray4 = kSSeed.CBCEncrypt(byArray5, byArray2, byArray3);
        }
        catch (KSException kSException) {
            kSException.printStackTrace();
        }
        return byArray4;
    }

    public static byte[] decryptSeed(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = null;
        try {
            KSSeed kSSeed = new KSSeed();
            byte[] byArray5 = kSSeed.CBCDecrypt(byArray, byArray2, byArray3);
            byte by = byArray5[byArray5.length - 1];
            if (by > 16) {
                System.out.println("invalid padding");
            }
            byArray4 = new byte[byArray5.length - by];
            System.arraycopy(byArray5, 0, byArray4, 0, byArray5.length - by);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray4;
    }

    public static byte[] encryptSeedNoPadding(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = null;
        int n2 = byArray.length;
        int n3 = n2 % 16;
        if (n3 != 0) {
            System.out.println("invalid block size!!!!");
            return null;
        }
        try {
            KSSeed kSSeed = new KSSeed();
            byArray4 = kSSeed.CBCEncrypt(byArray, byArray2, byArray3);
        }
        catch (KSException kSException) {
            kSException.printStackTrace();
        }
        return byArray4;
    }

    public static byte[] decryptSeedNoPadding(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = null;
        try {
            KSSeed kSSeed = new KSSeed();
            byArray4 = kSSeed.CBCDecrypt(byArray, byArray2, byArray3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray4;
    }

    public static int diffTime(byte[] byArray, byte[] byArray2) {
        return KSUtil.getTimeNum(byArray2) - KSUtil.getTimeNum(byArray);
    }

    public static byte[] intToByte(int n2) {
        int n3 = 0;
        byte[] byArray = new byte[4];
        byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 & 0xFF);
        return byArray;
    }

    public static char forDigit(int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            return '\u0000';
        }
        if (n3 < 2 || n3 > 36) {
            return '\u0000';
        }
        if (n2 < 10) {
            return (char)(48 + n2);
        }
        return (char)(87 + n2);
    }

    public static boolean isISOControl(char c2) {
        return c2 <= '\u009f' && (c2 <= '\u001f' || c2 >= '\u007f');
    }

    public static boolean bytesCmp(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        if (n2 != n3) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static String getVersion() {
        return ver;
    }

    public static String makeCertFilePath(String string) {
        String string2 = null;
        String string3 = null;
        File file = null;
        string3 = string.contains("/signCert.der") ? string.replace("/signCert.der", "") : (string.contains("/signPri.key") ? string.replace("/signPri.key", "") : string);
        file = new File(string3 + "/signCert.der");
        if (file.exists() && string3.indexOf("NPKI") > -1) {
            string2 = string3 + "/signCert.der";
        } else if (string3.indexOf("GPKI") > -1) {
            string2 = string3.contains("_sig.key") ? string3.replace("_sig.key", "_sig.cer") : string3;
        }
        if (string2 == null) {
            return string3;
        }
        return string2;
    }

    public static String makeKeyFilePath(String string) {
        String string2 = null;
        String string3 = null;
        File file = null;
        string3 = string.contains("/signCert.der") ? string.replace("/signCert.der", "") : (string.contains("/signPri.key") ? string.replace("/signPri.key", "") : string);
        file = new File(string3 + "/signPri.key");
        if (file.exists() && string3.indexOf("NPKI") > -1) {
            string2 = string3 + "/signPri.key";
        } else if (string3.indexOf("GPKI") > -1) {
            string2 = string3.contains("_sig.cer") ? string3.replace("_sig.cer", "_sig.key") : string3;
        }
        return string2;
    }

    public static void removeBytes(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    public static boolean isValidPassword(byte[] byArray) throws KSException {
        if (byArray.length < 10) {
            throw new KSException(-1501);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (byte by : byArray) {
            if (by == 39 || by == 92 || by == 124 || by == 34) {
                throw new KSException(-1505);
            }
            if (by >= 97 && by <= 122) {
                bl2 = true;
            }
            if (by >= 65 && by <= 90) {
                bl2 = true;
            }
            if (by >= 48 && by <= 57) {
                bl = true;
            }
            if (by >= 32 && by <= 47) {
                bl3 = true;
            }
            if (by >= 58 && by <= 64) {
                bl3 = true;
            }
            if (by >= 91 && by <= 96) {
                bl3 = true;
            }
            if (by < 123 || by > 126) continue;
            bl3 = true;
        }
        if (!bl2) {
            throw new KSException(-1502);
        }
        if (!bl) {
            throw new KSException(-1503);
        }
        if (!bl3) {
            throw new KSException(-1504);
        }
        return bl && bl2 && bl3;
    }

    static byte[] a(byte[] byArray) {
        byte[] byArray2 = new byte[]{25, 51, 19, 7, 17, 31, 3, -16, -85, -51, -17, 0, 9, 1, -103, 119};
        byte[] byArray3 = new byte[byArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            if (n3 >= byArray2.length) {
                n3 = 0;
            }
            byArray3[n2] = (byte)(byArray[n2] ^ byArray2[n3]);
            ++n2;
            ++n3;
        }
        return byArray3;
    }

    private static byte[] b(byte[] byArray) {
        byte[] byArray2 = new byte[]{7, 2, 0, 7, 1, 4, 1, 4, 8, 9, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int n2 = 1024;
        int n3 = 16;
        n n4 = new n();
        byte[] byArray3 = null;
        try {
            byArray3 = n4.b(byArray, byArray2, n2, n3);
        }
        catch (KSException kSException) {
            kSException.printStackTrace();
        }
        n4 = null;
        return byArray3;
    }

    public static byte[] getPasswdFromTranskeyEncData(byte[] byArray, byte[] byArray2) throws KSException {
        byte[] byArray3 = null;
        int n2 = 0;
        if (byArray == null || byArray2 == null) {
            throw new KSException(-3501);
        }
        byte[] byArray4 = KSUtil.a(a);
        byte[] byArray5 = KSUtil.b(byArray);
        KSSeed kSSeed = new KSSeed();
        try {
            byte[] byArray6 = kSSeed.CBCDecrypt(byArray2, byArray4, byArray5);
            for (n2 = 0; n2 < byArray6.length && byArray6[n2] != 0; ++n2) {
            }
            byArray3 = new byte[n2];
            System.arraycopy(byArray6, 0, byArray3, 0, byArray3.length);
            KSUtil.removeBytes(byArray6);
            byArray6 = null;
        }
        catch (KSException kSException) {
            throw kSException;
        }
        finally {
            kSSeed = null;
            KSUtil.removeBytes(byArray4);
            byArray4 = null;
            KSUtil.removeBytes(byArray5);
            byArray5 = null;
        }
        return byArray3;
    }
}

