/*
 * Decompiled with CFR 0.152.
 */
package com.lumensoft.ks;

import android.content.Context;
import android.os.Environment;
import com.lumensoft.ks.KSCertificate;
import com.lumensoft.ks.KSException;
import com.lumensoft.ks.KSPem;
import com.lumensoft.ks.KSUtil;
import com.lumensoft.ks.c;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class KSCertificateLoader
implements c {
    public static Vector getISPCertificateList(Context context, String[] stringArray) throws IOException, KSException {
        Vector<KSCertificate> vector = new Vector<KSCertificate>();
        for (String string : stringArray) {
            KSCertificate[] kSCertificateArray = KSCertificateLoader.a(string);
            if (kSCertificateArray == null) continue;
            for (KSCertificate kSCertificate : kSCertificateArray) {
                vector.add(kSCertificate);
            }
        }
        return vector;
    }

    public static Vector getISPCertificateList(Context context) throws IOException, KSException {
        String[] stringArray = new String[1];
        if (!Environment.getExternalStorageState().equals("mounted")) {
            stringArray[0] = context.getApplicationInfo().dataDir + "/" + "VCard" + "/";
        } else if (Environment.getExternalStorageState().equals("mounted")) {
            stringArray[0] = a + "/VCard/";
        }
        return KSCertificateLoader.getISPCertificateList(context, stringArray);
    }

    private static KSCertificate[] a(String string) throws IOException, KSException {
        int n2;
        KSCertificate[] kSCertificateArray = null;
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        Vector<KSCertificate> vector = new Vector<KSCertificate>();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            byte[] byArray = null;
            if (!stringArray[n2].contains(".cert")) continue;
            byArray = KSUtil.readFile(string + "/" + stringArray[n2]);
            vector.add(new KSCertificate(KSPem.decode(new String(byArray)), string, string + "/" + stringArray[n2], string + "/" + stringArray[n2].replace(".cert", ".priv")));
        }
        kSCertificateArray = new KSCertificate[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            kSCertificateArray[n2] = (KSCertificate)vector.get(n2);
        }
        return kSCertificateArray;
    }

    public static Vector cnCertFilter(Vector vector, String string) throws KSException {
        Vector<KSCertificate> vector2 = new Vector<KSCertificate>();
        String[] stringArray = null;
        if (string == null || string.equals("")) {
            return vector;
        }
        stringArray = string.split("\\|");
        if (stringArray != null && stringArray.length != 0) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                KSCertificate kSCertificate = (KSCertificate)vector.get(i2);
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    if (!kSCertificate.getIssuerCn().toLowerCase().equals(stringArray[i3].toLowerCase())) continue;
                    vector2.add(kSCertificate);
                }
            }
        }
        return vector2;
    }

    public static Iterable cnCertFilter(Iterable iterable, String string) {
        ArrayList<KSCertificate> arrayList = new ArrayList<KSCertificate>();
        if ("".equals(string)) {
            return arrayList;
        }
        if (string == null) {
            return arrayList;
        }
        String[] stringArray = string.split("\\|");
        if (stringArray == null || stringArray.length == 0) {
            return arrayList;
        }
        for (KSCertificate kSCertificate : iterable) {
            for (String string2 : stringArray) {
                if (!kSCertificate.getIssuerCn().toLowerCase().equals(string2.toLowerCase())) continue;
                arrayList.add(kSCertificate);
            }
        }
        return arrayList;
    }

    public static Iterable issuerCertFilter(Iterable iterable, String string) {
        ArrayList<KSCertificate> arrayList = new ArrayList<KSCertificate>();
        if ("".equals(string)) {
            return arrayList;
        }
        if (string == null) {
            return arrayList;
        }
        String[] stringArray = string.split("\\|");
        if (stringArray == null || stringArray.length == 0) {
            return arrayList;
        }
        for (KSCertificate kSCertificate : iterable) {
            for (String string2 : stringArray) {
                if (!kSCertificate.getIssuerDn().toLowerCase().equals(string2.toLowerCase())) continue;
                arrayList.add(kSCertificate);
            }
        }
        return arrayList;
    }

    public static Vector issuerCertFilter(Vector vector, String string) throws KSException {
        Vector<KSCertificate> vector2 = new Vector<KSCertificate>();
        String[] stringArray = null;
        if (string == null || string.equals("")) {
            return vector;
        }
        stringArray = string.split("\\|");
        if (stringArray != null && stringArray.length != 0) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                KSCertificate kSCertificate = (KSCertificate)vector.get(i2);
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    if (!kSCertificate.getIssuerDn().toLowerCase().equals(stringArray[i3].toLowerCase())) continue;
                    vector2.add(kSCertificate);
                }
            }
        }
        return vector2;
    }

    public static Iterable policyOidCertFilter(Iterable iterable, String string) {
        ArrayList<KSCertificate> arrayList = new ArrayList<KSCertificate>();
        if ("".equals(string)) {
            return arrayList;
        }
        if (string == null) {
            return arrayList;
        }
        String[] stringArray = string.split("\\|");
        if (stringArray == null || stringArray.length == 0) {
            return arrayList;
        }
        for (KSCertificate kSCertificate : iterable) {
            for (String string2 : stringArray) {
                if (!kSCertificate.getOID().toLowerCase().equals(string2.toLowerCase())) continue;
                arrayList.add(kSCertificate);
            }
        }
        return arrayList;
    }

    public static Vector policyOidCertFilter(Vector vector, String string) throws KSException {
        Vector<KSCertificate> vector2 = new Vector<KSCertificate>();
        String[] stringArray = null;
        if (string == null || string.equals("")) {
            return vector;
        }
        stringArray = string.split("\\|");
        if (stringArray != null && stringArray.length != 0) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                KSCertificate kSCertificate = (KSCertificate)vector.get(i2);
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    if (!kSCertificate.getOID().toLowerCase().equals(stringArray[i3].toLowerCase())) continue;
                    vector2.add(kSCertificate);
                }
            }
        }
        return vector2;
    }

    public static Vector FilterByExpiredTime(Vector vector) {
        Vector vector2 = new Vector();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            if (((KSCertificate)vector.get(i2)).isExpired()) continue;
            vector2.add(vector.get(i2));
        }
        return vector2;
    }

    public static Iterable FilterByExpiredTime(Iterable iterable) {
        ArrayList<KSCertificate> arrayList = new ArrayList<KSCertificate>();
        for (KSCertificate kSCertificate : iterable) {
            if (kSCertificate.isExpired()) continue;
            arrayList.add(kSCertificate);
        }
        return arrayList;
    }

    public static Vector getRootCertificateList(Context context) {
        Vector<KSCertificate> vector = new Vector<KSCertificate>();
        String string = KSCertificateLoader.a(KSCertificateLoader.getDefaultStorageRoot(context), "NPKI");
        KSCertificateLoader.a(context);
        for (String string2 : KSCertificateLoader.a()) {
            KSCertificate kSCertificate = KSCertificateLoader.a(string + string2);
            if (kSCertificate == null) continue;
            vector.addElement(kSCertificate);
        }
        return vector;
    }

    public static Vector getCACertificateList(Context context) {
        Vector<KSCertificate> vector = new Vector<KSCertificate>();
        String string = KSCertificateLoader.a(KSCertificateLoader.getDefaultStorageRoot(context), "NPKI");
        KSCertificateLoader.a(context);
        for (String string2 : KSCertificateLoader.a()) {
            KSCertificate kSCertificate = KSCertificateLoader.a(string + string2);
            if (kSCertificate == null) continue;
            vector.addElement(kSCertificate);
        }
        return vector;
    }

    public static Vector getUserCertificateList(Context context) throws KSException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        if (!Environment.getExternalStorageState().equals("mounted")) {
            KSCertificateLoader.a(context.getApplicationInfo().dataDir, context);
            File file = new File(context.getApplicationInfo().dataDir + "/" + "NPKI");
            String[] stringArray = file.list();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                try {
                    vector2 = KSCertificateLoader.a(context.getApplicationInfo().dataDir + "/" + "NPKI" + "/" + stringArray[i2] + "/" + "USER");
                    for (int i3 = 0; i3 < vector2.size(); ++i3) {
                        vector.addElement(vector2.elementAt(i3));
                    }
                    continue;
                }
                catch (Exception exception) {
                    vector2 = new Vector();
                }
            }
        } else if (Environment.getExternalStorageState().equals("mounted")) {
            KSCertificateLoader.a(a, context);
            File file = new File(a + "/" + "NPKI");
            String[] stringArray = file.list();
            for (int i4 = 0; i4 < stringArray.length; ++i4) {
                try {
                    vector2 = KSCertificateLoader.a(a + "/" + "NPKI" + "/" + stringArray[i4] + "/" + "USER");
                    for (int i5 = 0; i5 < vector2.size(); ++i5) {
                        vector.addElement(vector2.elementAt(i5));
                    }
                    continue;
                }
                catch (Exception exception) {
                    vector2 = new Vector();
                }
            }
            File file2 = new File(context.getApplicationInfo().dataDir + "/" + "NPKI");
            if (file2 != null) {
                KSCertificateLoader.a(context.getApplicationInfo().dataDir, context);
                String[] stringArray2 = file2.list();
                for (int i6 = 0; i6 < stringArray2.length; ++i6) {
                    try {
                        vector3 = KSCertificateLoader.a(context.getApplicationInfo().dataDir + "/" + "NPKI" + "/" + stringArray2[i6] + "/" + "USER");
                        for (int i7 = 0; i7 < vector3.size(); ++i7) {
                            vector.addElement(vector3.elementAt(i7));
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        vector2 = new Vector();
                    }
                }
            }
        } else {
            throw new KSException("Error : No Certificate Saving Place");
        }
        return vector;
    }

    public static Vector getUserCertificateListWithGpki(Context context) throws KSException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (!Environment.getExternalStorageState().equals("mounted")) {
            int n2;
            KSCertificateLoader.a(context.getApplicationInfo().dataDir, context);
            File file = new File(context.getApplicationInfo().dataDir + "/" + "NPKI");
            String[] stringArray = file.list();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                try {
                    vector2 = KSCertificateLoader.a(context.getApplicationInfo().dataDir + "/" + "NPKI" + "/" + stringArray[n2] + "/" + "USER");
                    for (int i2 = 0; i2 < vector2.size(); ++i2) {
                        vector.addElement(vector2.elementAt(i2));
                    }
                    continue;
                }
                catch (Exception exception) {
                    vector2 = new Vector();
                }
            }
            try {
                vector2 = KSCertificateLoader.b(context.getApplicationInfo().dataDir + "/" + "GPKI" + "/" + "Certificate" + "/" + "class2");
                for (n2 = 0; n2 < vector2.size(); ++n2) {
                    vector.addElement(vector2.elementAt(n2));
                }
            }
            catch (Exception exception) {
                vector2 = new Vector();
            }
        } else if (Environment.getExternalStorageState().equals("mounted")) {
            File file;
            int n3;
            int n4;
            KSCertificateLoader.a(a, context);
            File file2 = new File(a + "/" + "NPKI");
            String[] stringArray = file2.list();
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                try {
                    vector2 = KSCertificateLoader.a(a + "/" + "NPKI" + "/" + stringArray[n4] + "/" + "USER");
                    for (int i3 = 0; i3 < vector2.size(); ++i3) {
                        vector.addElement(vector2.elementAt(i3));
                    }
                    continue;
                }
                catch (Exception exception) {
                    vector2 = new Vector();
                }
            }
            try {
                vector2 = KSCertificateLoader.b(a + "/" + "GPKI" + "/" + "Certificate" + "/" + "class2");
                for (n4 = 0; n4 < vector2.size(); ++n4) {
                    vector.addElement(vector2.elementAt(n4));
                }
            }
            catch (Exception exception) {
                vector2 = new Vector();
            }
            File file3 = new File(context.getApplicationInfo().dataDir + "/" + "NPKI");
            if (file3.exists()) {
                KSCertificateLoader.a(context.getApplicationInfo().dataDir, context);
                String[] stringArray2 = file3.list();
                for (n3 = 0; n3 < stringArray2.length; ++n3) {
                    try {
                        vector2 = KSCertificateLoader.a(context.getApplicationInfo().dataDir + "/" + "NPKI" + "/" + stringArray2[n3] + "/" + "USER");
                        for (int i4 = 0; i4 < vector2.size(); ++i4) {
                            vector.addElement(vector2.elementAt(i4));
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        vector2 = new Vector();
                    }
                }
            }
            if ((file = new File(context.getApplicationInfo().dataDir + "/" + "GPKI" + "/" + "Certificate" + "/" + "class2")).exists()) {
                try {
                    vector2 = KSCertificateLoader.b(context.getApplicationInfo().dataDir + "/" + "GPKI" + "/" + "Certificate" + "/" + "class2");
                    for (n3 = 0; n3 < vector2.size(); ++n3) {
                        vector.addElement(vector2.elementAt(n3));
                    }
                }
                catch (Exception exception) {
                    vector2 = new Vector();
                }
            }
        } else {
            throw new KSException("Error : No Certificate Saving Place");
        }
        return vector;
    }

    public static Vector getUserCertificateListWithGpki(String string, Context context) throws KSException {
        int n2;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        KSCertificateLoader.a(string, context);
        File file = new File(string + "/" + "NPKI");
        String[] stringArray = file.list();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            try {
                vector2 = KSCertificateLoader.a(string + "/" + "NPKI" + "/" + stringArray[n2] + "/" + "USER");
                for (int i2 = 0; i2 < vector2.size(); ++i2) {
                    vector.addElement(vector2.elementAt(i2));
                }
                continue;
            }
            catch (Exception exception) {
                vector2 = new Vector();
            }
        }
        try {
            vector2 = KSCertificateLoader.b(string + "/" + "GPKI" + "/" + "Certificate" + "/" + "class2");
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                vector.addElement(vector2.elementAt(n2));
            }
        }
        catch (Exception exception) {
            vector2 = new Vector();
        }
        return vector;
    }

    public static Vector getGpkiUserCertificateList(Context context) throws KSException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (!Environment.getExternalStorageState().equals("mounted")) {
            try {
                vector2 = KSCertificateLoader.b(context.getApplicationInfo().dataDir + "/" + "GPKI" + "/" + "Certificate" + "/" + "class2");
                for (int i2 = 0; i2 < vector2.size(); ++i2) {
                    vector.addElement(vector2.elementAt(i2));
                }
            }
            catch (Exception exception) {
                vector2 = new Vector();
            }
        } else if (Environment.getExternalStorageState().equals("mounted")) {
            try {
                vector2 = KSCertificateLoader.b(a + "/" + "GPKI" + "/" + "Certificate" + "/" + "class2");
                for (int i3 = 0; i3 < vector2.size(); ++i3) {
                    vector.addElement(vector2.elementAt(i3));
                }
            }
            catch (Exception exception) {
                vector2 = new Vector();
            }
            File file = new File(context.getApplicationInfo().dataDir + "/" + "GPKI" + "/" + "Certificate" + "/" + "class2");
            if (file.exists()) {
                try {
                    vector2 = KSCertificateLoader.b(context.getApplicationInfo().dataDir + "/" + "GPKI" + "/" + "Certificate" + "/" + "class2");
                    for (int i4 = 0; i4 < vector2.size(); ++i4) {
                        vector.addElement(vector2.elementAt(i4));
                    }
                }
                catch (Exception exception) {
                    vector2 = new Vector();
                }
            }
        }
        return vector;
    }

    public static int getUserCertificate(String string, Context context) throws UnsupportedEncodingException, KSException {
        if (string == null) {
            return -3006;
        }
        Vector vector = KSCertificateLoader.getUserCertificateList(context);
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            if (!((KSCertificate)vector.elementAt(i2)).getSubjectDn().toLowerCase().trim().equals(string.toLowerCase().trim())) continue;
            return i2;
        }
        return -3006;
    }

    private static KSCertificate a(String string) {
        KSCertificate kSCertificate = null;
        String string2 = string + "/signCert.der";
        File file = new File(string2);
        if (file.exists()) {
            byte[] byArray = null;
            try {
                byArray = KSUtil.readFile(string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                kSCertificate = new KSCertificate(byArray, string, string2, "null");
            }
            catch (KSException kSException) {
                kSException.printStackTrace();
            }
        }
        return kSCertificate;
    }

    private static Vector a(String string) throws Exception {
        File file = new File(string);
        String[] stringArray = null;
        Vector<KSCertificate> vector = new Vector<KSCertificate>();
        if (file.exists() && file.isDirectory()) {
            stringArray = file.list();
            if (stringArray == null) {
                throw new Exception();
            }
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = string + "/" + stringArray[i2];
                try {
                    String string3 = string2 + "/signCert.der";
                    String string4 = string2 + "/signPri.key";
                    byte[] byArray = KSUtil.readFile(string3);
                    vector.addElement(new KSCertificate(byArray, string2, string3, string4));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return vector;
    }

    private static Vector b(String string) throws Exception {
        File file = new File(string);
        String[] stringArray = null;
        Vector<KSCertificate> vector = new Vector<KSCertificate>();
        if (file.exists()) {
            stringArray = file.list();
            if (stringArray == null) {
                throw new Exception();
            }
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = stringArray[i2].indexOf("_sig.cer");
                if (n3 == -1) continue;
                String string2 = string + "/" + stringArray[i2];
                String string3 = string2.replace("_sig.cer", "_sig.key");
                try {
                    byte[] byArray = KSUtil.readFile(string2);
                    vector.addElement(new KSCertificate(byArray, string, string2, string3));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return vector;
    }

    static void a(String string, Context context) {
        File file = new File(string + "/" + "NPKI");
        if (!file.exists()) {
            file.mkdirs();
        }
        for (String string2 : KSCertificateLoader.a()) {
            file = new File(string + "/" + "NPKI" + "/" + string2);
            if (file.exists()) continue;
            file.mkdirs();
        }
        file = new File(string + "/" + "GPKI");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(string + "/" + "GPKI" + "/" + "Certificate")).exists()) {
            file.mkdirs();
        }
        if (!(file = new File(string + "/" + "GPKI" + "/" + "Certificate" + "/" + "class1")).exists()) {
            file.mkdirs();
        }
        if (!(file = new File(string + "/" + "GPKI" + "/" + "Certificate" + "/" + "class2")).exists()) {
            file.mkdirs();
        }
    }

    public static String getAbsolutePath(String string, String string2, Context context) {
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!"mounted".equals(string)) {
            return context.getApplicationInfo().dataDir + string2;
        }
        return Environment.getExternalStorageDirectory().getPath() + string2;
    }

    public static String getAbsolutePath(String string, Context context) {
        return KSCertificateLoader.getAbsolutePath(string, "/", context);
    }

    public static Iterable getCertificateListfromApp(Context context) throws KSException, IOException {
        return KSCertificateLoader.getCertificateList(context, new String[]{KSCertificateLoader.getAbsolutePath("app", context)});
    }

    public static Iterable getCertificateListfromSDCard(Context context) throws KSException, IOException {
        return KSCertificateLoader.getCertificateList(context, new String[]{KSCertificateLoader.getAbsolutePath("mounted", context)});
    }

    public static Iterable getCertificateList(Context context, String[] stringArray) throws KSException, IOException {
        return KSCertificateLoader.getCertificateList(context, stringArray, "NPKI");
    }

    public static Iterable getCertificateListfromAppWithGpki(Context context) throws KSException, IOException {
        return KSCertificateLoader.getCertificateListWithGpki(context, new String[]{KSCertificateLoader.getAbsolutePath("app", context)});
    }

    public static Iterable getCertificateListfromAppWithGpki(Context context, String string) throws KSException, IOException {
        return KSCertificateLoader.getCertificateListWithGpki(context, new String[]{KSCertificateLoader.getAbsolutePath("app", context) + string});
    }

    public static Iterable getCertificateListfromSDCardWithGpki(Context context) throws KSException, IOException {
        return KSCertificateLoader.getCertificateListWithGpki(context, new String[]{KSCertificateLoader.getAbsolutePath("mounted", context)});
    }

    public static Iterable getCertificateListWithGpki(Context context, String[] stringArray) throws KSException, IOException {
        ArrayList<KSCertificate> arrayList = new ArrayList<KSCertificate>();
        Iterable iterable = KSCertificateLoader.getCertificateList(context, stringArray, "NPKI");
        Iterable iterable2 = KSCertificateLoader.getCertificateList(context, stringArray, "GPKI");
        for (KSCertificate kSCertificate : iterable) {
            arrayList.add(kSCertificate);
        }
        for (KSCertificate kSCertificate : iterable2) {
            arrayList.add(kSCertificate);
        }
        return arrayList;
    }

    public static Iterable getCertificateList(Context context, String[] stringArray, String string) throws KSException, IOException {
        ArrayList<KSCertificate> arrayList;
        block8: {
            block7: {
                arrayList = new ArrayList<KSCertificate>();
                if (string != "NPKI") break block7;
                for (String string2 : stringArray) {
                    KSCertificateLoader.a(string2, context);
                    for (String string3 : KSCertificateLoader.a()) {
                        List list = KSCertificateLoader.a(string2 + "/" + string + "/" + string3 + "/");
                        if (list == null) continue;
                        for (KSCertificate kSCertificate : list) {
                            if (!kSCertificate.isValidFormat()) continue;
                            arrayList.add(kSCertificate);
                        }
                    }
                }
                break block8;
            }
            if (string != "GPKI") break block8;
            for (String string4 : stringArray) {
                Vector vector;
                KSCertificateLoader.a(string4, context);
                try {
                    vector = KSCertificateLoader.b(string4 + "/" + string + "/" + "Certificate" + "/" + "class2");
                    if (vector == null) continue;
                    for (KSCertificate kSCertificate : vector) {
                        if (!kSCertificate.isValidFormat()) continue;
                        arrayList.add(kSCertificate);
                    }
                }
                catch (Exception exception) {
                    vector = new Vector();
                }
            }
        }
        return arrayList;
    }

    public static Vector getCertificateListAsVector(Context context, String[] stringArray) throws KSException {
        try {
            return KSCertificateLoader.IterableToVector(KSCertificateLoader.getCertificateList(context, stringArray));
        }
        catch (IOException iOException) {
            throw new KSException(-3604);
        }
    }

    public static Vector getCertificateListfromAppAsVector(Context context) throws KSException {
        try {
            return KSCertificateLoader.IterableToVector(KSCertificateLoader.getCertificateList(context, new String[]{KSCertificateLoader.getAbsolutePath("app", context)}));
        }
        catch (IOException iOException) {
            throw new KSException(-3604);
        }
    }

    public static Vector getCertificateListfromSDCardAsVector(Context context) throws KSException {
        try {
            return KSCertificateLoader.IterableToVector(KSCertificateLoader.getCertificateList(context, new String[]{KSCertificateLoader.getAbsolutePath("mounted", context)}));
        }
        catch (IOException iOException) {
            throw new KSException(-3604);
        }
    }

    public static Vector getCertificateListWithGpkiAsVector(Context context, String[] stringArray) throws KSException {
        try {
            return KSCertificateLoader.IterableToVector(KSCertificateLoader.getCertificateListWithGpki(context, stringArray));
        }
        catch (IOException iOException) {
            throw new KSException(-3604);
        }
    }

    public static Vector getCertificateListfromAppWithGpkiAsVector(Context context) throws KSException {
        try {
            return KSCertificateLoader.IterableToVector(KSCertificateLoader.getCertificateListWithGpki(context, new String[]{KSCertificateLoader.getAbsolutePath("app", context)}));
        }
        catch (IOException iOException) {
            throw new KSException(-3604);
        }
    }

    public static Vector getCertificateListfromAppWithGpkiAsVector(Context context, String string) throws KSException {
        try {
            return KSCertificateLoader.IterableToVector(KSCertificateLoader.getCertificateListfromAppWithGpki(context, string));
        }
        catch (IOException iOException) {
            throw new KSException(-3604);
        }
    }

    public static Vector getCertificateListfromSDCardWithGpkiAsVector(Context context) throws KSException {
        try {
            return KSCertificateLoader.IterableToVector(KSCertificateLoader.getCertificateListWithGpki(context, new String[]{KSCertificateLoader.getAbsolutePath("mounted", context)}));
        }
        catch (IOException iOException) {
            throw new KSException(-3604);
        }
    }

    public static Vector IterableToVector(Iterable iterable) {
        Vector<KSCertificate> vector = new Vector<KSCertificate>();
        if (iterable == null) {
            return vector;
        }
        for (KSCertificate kSCertificate : iterable) {
            vector.add(kSCertificate);
        }
        return vector;
    }

    private static String[] a() {
        return new String[]{"KISA", "yessign", "SignKorea", "KICA", "CrossCert", "TradeSign", "NCASign"};
    }

    private static List a(String string) throws KSException, IOException {
        Object var1_1 = null;
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string2 : stringArray) {
            Object object2;
            List list;
            if (new File(string + "/" + string2).isDirectory() && (list = KSCertificateLoader.a(string + "/" + string2)) != null) {
                for (Object object2 : list) {
                    if (!((KSCertificate)object2).isValidFormat()) continue;
                    arrayList.add(object2);
                }
            }
            if (!string2.contains(".der")) continue;
            boolean bl = false;
            String string3 = new File(string + "/" + string2).getParentFile().getName();
            object2 = KSCertificateLoader.a();
            int n2 = ((String[])object2).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string4 = object2[i2];
                bl |= string3.equals(string4);
            }
            if (bl || string2.contains("kmCert") || !((KSCertificate)(object2 = new KSCertificate(KSUtil.readFile(string + "/" + string2), string + "/"))).isValidFormat()) continue;
            arrayList.add(object2);
        }
        return arrayList;
    }

    private static String a(String ... stringArray) {
        String string = "";
        for (String string2 : stringArray) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            string = string + string2;
        }
        return string;
    }

    private static void a(Context context) {
        KSCertificateLoader.a(KSCertificateLoader.getDefaultStorageRoot(context), context);
    }

    private static boolean a() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getDefaultStorageRoot(Context context) {
        return KSCertificateLoader.a() ? KSCertificateLoader.a(new String[]{a}) : context.getApplicationInfo().dataDir;
    }
}

