/*
 * Decompiled with CFR 0.152.
 */
package com.raonsecure.touchen_mguard_4_0.utils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Looper;
import com.raonsecure.touchen_mguard_4_0.utils.DownloadProcessor;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class FileDownloadProgressDialog {
    private static final String TAG = FileDownloadProgressDialog.class.getSimpleName();
    private Activity view;
    private DownloadProcessor.DownloadHandler viewDownloadHandler;
    private DownloadProcessor downloadProcessor;
    private ProgressDialog progressDialog;
    private int itemTotalCount = 0;
    private int itemDownloadedCount = 0;
    private int itemSize;
    private int itemSizeOffset;
    private static double SPACE_KB = 1024.0;
    private static double SPACE_MB = 1024.0 * SPACE_KB;
    private static double SPACE_GB = 1024.0 * SPACE_MB;
    private static double SPACE_TB = 1024.0 * SPACE_GB;
    DownloadProcessor.DownloadHandler downloadHandler = new DownloadProcessor.DownloadHandler(Looper.getMainLooper()){
        private int progressIndex;
        private static final int PROGRESS_STEP_COUNT = 50;
        private int progressStepSize;
        {
            this.progressIndex = 0;
            this.progressStepSize = 0;
        }

        @Override
        public void sendSetLength(long length) {
            FileDownloadProgressDialog.this.itemSize = (int)length;
            FileDownloadProgressDialog.this.itemSizeOffset = 0;
            if (FileDownloadProgressDialog.this.progressDialog != null) {
                FileDownloadProgressDialog.this.progressDialog.setMax(FileDownloadProgressDialog.this.itemSize);
                FileDownloadProgressDialog.this.progressDialog.setProgress(FileDownloadProgressDialog.this.itemSizeOffset);
                FileDownloadProgressDialog.this.progressDialog.setSecondaryProgress(0);
            }
            this.progressStepSize = FileDownloadProgressDialog.this.itemSize / 50;
        }

        @Override
        public void sendOnRecv(long recvd) {
            FileDownloadProgressDialog.this.itemSizeOffset = (int)recvd;
            if (FileDownloadProgressDialog.this.progressDialog != null && recvd > (long)(this.progressStepSize * this.progressIndex)) {
                ++this.progressIndex;
                FileDownloadProgressDialog.this.progressDialog.setProgress(FileDownloadProgressDialog.this.itemSizeOffset);
                FileDownloadProgressDialog.this.progressDialog.setProgressNumberFormat(FileDownloadProgressDialog.bytes2String(FileDownloadProgressDialog.this.itemSizeOffset) + "/" + FileDownloadProgressDialog.bytes2String(FileDownloadProgressDialog.this.itemSize));
            }
        }

        @Override
        public void sendFinished() {
            FileDownloadProgressDialog.this.progressFinish();
            if (FileDownloadProgressDialog.this.viewDownloadHandler != null) {
                FileDownloadProgressDialog.this.viewDownloadHandler.sendFinished();
            }
        }

        @Override
        public void sendError(String errmsg) {
            FileDownloadProgressDialog.this.progressFinish();
            if (FileDownloadProgressDialog.this.viewDownloadHandler != null) {
                FileDownloadProgressDialog.this.viewDownloadHandler.sendError(errmsg);
            }
        }

        @Override
        public void sendAborted() {
            FileDownloadProgressDialog.this.progressFinish();
            if (FileDownloadProgressDialog.this.viewDownloadHandler != null) {
                FileDownloadProgressDialog.this.viewDownloadHandler.sendAborted();
            }
        }

        @Override
        public void sendDownloaded(DownloadProcessor.Download download) {
            FileDownloadProgressDialog.this.itemDownloadedCount++;
            if (FileDownloadProgressDialog.this.progressDialog != null) {
                FileDownloadProgressDialog.this.progressDialog.setSecondaryProgress(FileDownloadProgressDialog.this.itemTotalCount * 100 / FileDownloadProgressDialog.this.itemDownloadedCount);
            }
        }
    };

    public static String bytes2String(int Bytes) {
        DecimalFormat nf = new DecimalFormat();
        ((NumberFormat)nf).setMaximumFractionDigits(2);
        long sizeInBytes = Bytes;
        try {
            if ((double)sizeInBytes < SPACE_KB) {
                return nf.format(sizeInBytes) + " Byte(s)";
            }
            if ((double)sizeInBytes < SPACE_MB) {
                return nf.format((double)sizeInBytes / SPACE_KB) + " KB";
            }
            if ((double)sizeInBytes < SPACE_GB) {
                return nf.format((double)sizeInBytes / SPACE_MB) + " MB";
            }
            if ((double)sizeInBytes < SPACE_TB) {
                return nf.format((double)sizeInBytes / SPACE_GB) + " GB";
            }
            return nf.format((double)sizeInBytes / SPACE_TB) + " TB";
        }
        catch (Exception e) {
            return sizeInBytes + " Byte(s)";
        }
    }

    public FileDownloadProgressDialog(Activity view, DownloadProcessor.DownloadHandler downloadHandler) {
        this.view = view;
        this.viewDownloadHandler = downloadHandler;
        this.progressFinish();
        this.progressDialog = new ProgressDialog((Context)view);
        this.progressDialog.setProgressStyle(1);
    }

    private void progressFinish() {
        if (this.progressDialog != null && this.progressDialog.isShowing()) {
            this.progressDialog.dismiss();
            this.progressDialog.cancel();
            this.progressDialog = null;
        }
    }

    public void download(int downloadType, String[] sourceUrls, String[] destFiles, boolean isCancelable) {
        this.itemDownloadedCount = 0;
        this.progressDialog.setCanceledOnTouchOutside(false);
        this.progressDialog.setCancelable(isCancelable);
        this.progressDialog.setMessage((CharSequence)"Download...");
        if (isCancelable) {
            this.progressDialog.setButton(-3, (CharSequence)"\ucde8\uc18c", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (FileDownloadProgressDialog.this.downloadProcessor != null) {
                        FileDownloadProgressDialog.this.downloadProcessor.abort();
                    }
                }
            });
        }
        this.progressDialog.show();
        this.downloadProcessor = DownloadProcessor.startDownload((Context)this.view, this.downloadHandler, downloadType, sourceUrls, destFiles);
        if (this.downloadProcessor != null) {
            this.itemTotalCount = this.downloadProcessor.getDownloadCount();
        }
    }

    public void cancelDownload() {
        if (this.progressDialog != null && this.progressDialog.isShowing()) {
            this.progressDialog.dismiss();
            this.progressDialog.cancel();
            this.progressDialog = null;
        }
    }
}

