/*
 * Decompiled with CFR 0.152.
 */
package kr.co.clipsoft.eform.type.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class XmlElement {
    private ArrayList<XmlElement> _childNodes = new ArrayList();
    private HashMap<String, String> _attributes = new HashMap();
    private XmlElement _parent = null;
    private String _xpath = "";
    private String _value = "";
    private String _tagName = "";
    private boolean _saveCData = false;

    public XmlElement(String tagName, XmlElement parent) {
        this._tagName = tagName;
        this._parent = parent;
        this.refreshXPath();
    }

    public void refreshXPath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._parent != null) {
            stringBuffer.append(this._parent.getXpath());
            stringBuffer.append("/");
            stringBuffer.append(this._tagName);
            this._xpath = stringBuffer.toString();
            if (!this._parent.getChildNodes().contains(this)) {
                this._parent.getChildNodes().add(this);
            }
        } else {
            stringBuffer.append("/");
            stringBuffer.append(this._tagName);
            this._xpath = stringBuffer.toString();
        }
        for (XmlElement xmlElement : this._childNodes) {
            xmlElement.refreshXPath();
        }
    }

    public XmlElement getParent() {
        return this._parent;
    }

    public void setParent(XmlElement parent, boolean refreshXPath) {
        this._parent = parent;
        if (refreshXPath) {
            this.refreshXPath();
        } else if (!this._parent.getChildNodes().contains(this)) {
            this._parent.getChildNodes().add(this);
        }
    }

    public String getTagName() {
        return this._tagName;
    }

    public void setTagName(String tagName) {
        this._tagName = tagName;
    }

    public ArrayList<XmlElement> getChildNodes() {
        return this._childNodes;
    }

    public String getAttribute(String name) {
        return this._attributes.get(name);
    }

    public HashMap<String, String> getAttributes() {
        return this._attributes;
    }

    public boolean containAttribute(String name) {
        return this._attributes.containsKey(name);
    }

    public String getXpath() {
        return this._xpath;
    }

    public void setXpath(String xpath) {
        this._xpath = xpath;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void appendChild(XmlElement child, boolean refreshXPath) {
        child.setParent(this, refreshXPath);
    }

    public void appendChildNodes(List<XmlElement> childNodes, boolean refreshXPath) {
        for (XmlElement xmlElement : childNodes) {
            xmlElement.setParent(this, refreshXPath);
        }
    }

    public void removeChild(XmlElement child) {
        this._childNodes.remove(child);
    }

    public void removeChild(int index) {
        this._childNodes.remove(index);
    }

    public void removeChild(String tagName) {
        for (int i = this._childNodes.size() - 1; i >= 0; --i) {
            if (!this._childNodes.get(i).getTagName().equalsIgnoreCase(tagName)) continue;
            this._childNodes.remove(i);
        }
    }

    public void clearChildElement() {
        this._childNodes.clear();
    }

    public void getElementByTagName(ArrayList<XmlElement> xmlElementList, String tagName) {
        for (XmlElement xmlElement : this._childNodes) {
            if (xmlElement.getTagName().equalsIgnoreCase(tagName)) {
                xmlElementList.add(xmlElement);
            }
            if (xmlElement.getChildNodes().size() <= 0) continue;
            xmlElement.getElementByTagName(xmlElementList, tagName);
        }
    }

    public ArrayList<XmlElement> getElementByTagName(String tagName) {
        ArrayList<XmlElement> xmlElementList = new ArrayList<XmlElement>();
        this.getElementByTagName(xmlElementList, tagName);
        return xmlElementList;
    }

    public void getElementByXpath(String xpath, ArrayList<XmlElement> xmlElementList) {
        for (XmlElement xmlElement : this._childNodes) {
            if (!xpath.startsWith(xmlElement.getXpath())) continue;
            if (xpath.equalsIgnoreCase(xmlElement.getXpath())) {
                xmlElementList.add(xmlElement);
                continue;
            }
            if (xmlElement.getChildNodes().size() <= 0) continue;
            xmlElement.getElementByXpath(xpath, xmlElementList);
        }
    }

    public ArrayList<XmlElement> getElementByXpath(String xpath) {
        ArrayList<XmlElement> xmlElementList = new ArrayList<XmlElement>();
        this.getElementByXpath(xpath, xmlElementList);
        return xmlElementList;
    }

    public void appendAttribute(String name, String value) {
        this._attributes.put(name, value);
    }

    public void appendAttribute(HashMap<String, String> attributes) {
        this._attributes.putAll(attributes);
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public void removeAttribute(int index) {
        this._attributes.remove(index);
    }

    public String getXmlString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getXmlString(stringBuffer);
        String result = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringBuffer = null;
        return result;
    }

    public void getXmlString(StringBuffer stringBuffer) {
        StringBuffer thisStringBuffer;
        block7: {
            block5: {
                block6: {
                    thisStringBuffer = new StringBuffer();
                    thisStringBuffer.append("<");
                    thisStringBuffer.append(this._tagName);
                    for (String key : this._attributes.keySet()) {
                        String value = this._attributes.get(key);
                        if (value != null && !value.trim().equals("")) {
                            value = this.getStringConvertToXmlAttributeValue(this._attributes.get(key));
                        }
                        thisStringBuffer.append(" ");
                        thisStringBuffer.append(key);
                        thisStringBuffer.append("=\"");
                        thisStringBuffer.append(value);
                        thisStringBuffer.append("\"");
                    }
                    thisStringBuffer.append(">");
                    if (this._childNodes.size() != 0) break block5;
                    if (this._value == null || this._value.trim().equals("")) break block6;
                    if (this._saveCData) {
                        thisStringBuffer.append("<![CDATA[");
                        thisStringBuffer.append(this._value);
                        thisStringBuffer.append("]]>");
                    } else {
                        thisStringBuffer.append(this.getStringConvertToXmlAttributeValue(this._value));
                    }
                    break block7;
                }
                if (!this._saveCData) break block7;
                thisStringBuffer.append("<![CDATA[]]>");
                break block7;
            }
            for (XmlElement xmlElement : this._childNodes) {
                xmlElement.getXmlString(thisStringBuffer);
            }
        }
        thisStringBuffer.append("</");
        thisStringBuffer.append(this._tagName);
        thisStringBuffer.append(">");
        stringBuffer.append(thisStringBuffer.toString());
        thisStringBuffer = null;
    }

    public boolean isSaveCData() {
        return this._saveCData;
    }

    public void setSaveCData(boolean saveCData) {
        this._saveCData = saveCData;
    }

    private String getStringConvertToXmlAttributeValue(String resultValue) {
        if (resultValue.indexOf("&") != -1) {
            resultValue = resultValue.replace("&", "&amp;");
        }
        if (resultValue.indexOf("\"") != -1) {
            resultValue = resultValue.replace("\"", "&quot;");
        }
        if (resultValue.indexOf("'") != -1) {
            resultValue = resultValue.replace("'", "&apos;");
        }
        if (resultValue.indexOf("<") != -1) {
            resultValue = resultValue.replace("<", "&lt;");
        }
        if (resultValue.indexOf(">") != -1) {
            resultValue = resultValue.replace(">", "&gt;");
        }
        if (resultValue.indexOf("\r") != -1) {
            resultValue = resultValue.replace("\r", "&#xD;");
        }
        if (resultValue.indexOf("\n") != -1) {
            resultValue = resultValue.replace("\n", "&#xA;");
        }
        return resultValue;
    }

    public XmlElement clone() {
        XmlElement xmlElement = new XmlElement(this._tagName, null);
        xmlElement.setValue(this._value);
        xmlElement.setSaveCData(this._saveCData);
        xmlElement.appendAttribute(this._attributes);
        for (XmlElement child : this._childNodes) {
            xmlElement.appendChild(child.clone(), false);
        }
        xmlElement.refreshXPath();
        return xmlElement;
    }

    public void removeAttributeAll() {
        this._attributes.clear();
    }
}

