/*
 * Decompiled with CFR 0.152.
 */
package com.raonsecure.touchen_mguard_4_0.utils;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.raonsecure.touchen_mguard_4_0.utils.AllowAllX509TrustManager;
import com.raonsecure.touchen_mguard_4_0.utils.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class DownloadProcessor
extends Thread {
    private static final String TAG = DownloadProcessor.class.getSimpleName();
    public static final int DOWNLOAD_SKIP = 0;
    public static final int DOWNLOAD_OVERWRITE = 1;
    public static final int DOWNLOAD_APPEND = 2;
    private Download[] mDownloads;
    private DownloadHandler mHandler;
    protected volatile boolean mStopped = false;
    private static AllowAllX509TrustManager mAllowAllX509TrustManager;
    static final HostnameVerifier DO_NOT_VERIFY;

    public DownloadProcessor(Download[] dls, DownloadHandler handler) {
        this.mDownloads = dls;
        this.mHandler = handler;
        try {
            mAllowAllX509TrustManager = new AllowAllX509TrustManager(null);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        for (Download d : this.mDownloads) {
            if (this.mStopped) continue;
            this.download(d);
            if (1 != d.downloadType || d.backup == null || !d.backup.exists()) continue;
            d.backup.delete();
        }
        if (!this.mStopped) {
            if (this.mHandler != null) {
                this.mHandler.sendFinished();
            }
        } else if (this.mHandler != null) {
            this.mHandler.sendAborted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(Download d) {
        Log.d((String)TAG, (String)("downloadImage: " + d.url.toString()));
        InputStream in = null;
        RandomAccessFile out = null;
        try {
            URL url = d.url;
            HttpURLConnection conn = null;
            if (url.getProtocol().toLowerCase(Locale.getDefault()).equals("https")) {
                DownloadProcessor.trustAllHosts();
                HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
                https.setHostnameVerifier(DO_NOT_VERIFY);
                conn = https;
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
            if (conn != null) {
                long offset;
                if (1 == d.downloadType) {
                    d.backup();
                    d.getDestination().delete();
                }
                if ((offset = d.getDestination().length()) > 0L) {
                    conn.setRequestProperty("Range", "bytes=" + offset + '-');
                }
                conn.setConnectTimeout(10000);
                conn.setUseCaches(false);
                int resultcode = conn.getResponseCode();
                if (resultcode == 200 || resultcode == 206) {
                    int n;
                    long len = offset;
                    if ((len += (long)conn.getContentLength()) >= 0L && !this.mStopped && this.mHandler != null) {
                        this.mHandler.sendSetLength(len);
                    }
                    in = conn.getInputStream();
                    out = new RandomAccessFile(d.getDestination().getAbsolutePath(), "rw");
                    if (offset > 0L) {
                        if (!this.mStopped && this.mHandler != null) {
                            this.mHandler.sendOnRecv(offset);
                        }
                        out.seek(offset);
                    }
                    byte[] b = new byte[2048];
                    long bytes = offset;
                    while (!this.mStopped && (n = in.read(b)) >= 0) {
                        bytes += (long)n;
                        if (!this.mStopped && this.mHandler != null) {
                            this.mHandler.sendOnRecv(bytes);
                        }
                        out.write(b, 0, n);
                    }
                    if (!this.mStopped && this.mHandler != null) {
                        this.mHandler.sendDownloaded(d);
                    }
                } else if (!this.mStopped) {
                    if (resultcode == 416) {
                        HttpURLConnection conn2 = null;
                        if (url.getProtocol().toLowerCase(Locale.getDefault()).equals("https")) {
                            DownloadProcessor.trustAllHosts();
                            HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
                            https.setHostnameVerifier(DO_NOT_VERIFY);
                            conn2 = https;
                        } else {
                            conn2 = (HttpURLConnection)url.openConnection();
                        }
                        int contentLength = conn2.getContentLength();
                        conn2.disconnect();
                        if (offset == (long)contentLength) {
                            if (!this.mStopped && this.mHandler != null) {
                                this.mHandler.sendDownloaded(d);
                            }
                        } else {
                            String message = "conn.getResponseCode() : " + resultcode;
                            if (!this.mStopped && this.mHandler != null) {
                                this.mHandler.sendError(message);
                            }
                            Log.d((String)TAG, (String)message);
                        }
                    } else {
                        String message = "conn.getResponseCode() : " + resultcode;
                        if (!this.mStopped && this.mHandler != null) {
                            this.mHandler.sendError(message);
                        }
                        Log.d((String)TAG, (String)message);
                    }
                }
                conn.disconnect();
            }
        }
        catch (Exception ex) {
            if (!this.mStopped) {
                d.abortCleanup();
                if (this.mHandler != null) {
                    this.mHandler.sendError(ex.getLocalizedMessage());
                }
                Log.d((String)TAG, (String)("Unexpected error : " + ex));
                ex.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    if (!this.mStopped && this.mHandler != null) {
                        this.mHandler.sendError("Error writing output: " + e.getLocalizedMessage());
                    }
                    return;
                }
                if (this.mStopped) {
                    d.abortCleanup();
                }
            }
        }
    }

    private static void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return mAllowAllX509TrustManager.getAcceptedIssuers();
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                mAllowAllX509TrustManager.checkClientTrusted(chain, authType);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                mAllowAllX509TrustManager.checkServerTrusted(chain, authType);
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{mAllowAllX509TrustManager}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getDownloadCount() {
        int count = 0;
        if (this.mDownloads != null) {
            count = this.mDownloads.length;
        }
        return count;
    }

    public void abort() {
        this.mStopped = true;
    }

    public static DownloadProcessor startDownloadPrestUrl(Context context, DownloadHandler cbHandler, int downloadType, String folderPath, String[] fileNames, String downForderPath, String[] downFileNames) {
        return null;
    }

    public static DownloadProcessor startDownload(Context context, DownloadHandler cbHandler, int downloadType, String[] sourceUrls, String[] destFiles) {
        DownloadProcessor downloadProcessor = null;
        if (sourceUrls == null || sourceUrls.length == 0) {
            Log.d((String)TAG, (String)"downloadFile (sourceUrls is null)");
            return downloadProcessor;
        }
        if (destFiles == null || destFiles.length < 1) {
            Log.d((String)TAG, (String)"downloadFile (destFiles is null)");
            return downloadProcessor;
        }
        if (sourceUrls.length != destFiles.length) {
            Log.d((String)TAG, (String)"downloadFile (item count mismatch)");
            return downloadProcessor;
        }
        try {
            ArrayList<Download> downItemList = new ArrayList<Download>();
            for (int i = 0; i < destFiles.length; ++i) {
                Log.d((String)TAG, (String)("destFiles : " + destFiles[i]));
                File dest = new File(destFiles[i]);
                if (dest.exists() && downloadType != 1 && downloadType != 2) {
                    Log.d((String)TAG, (String)("downloadfile : file(" + destFiles[i] + ") is already exists. DOWNLOAD_SKIP"));
                    continue;
                }
                Download downItem = new Download(new URL(sourceUrls[i]), dest, downloadType);
                downItemList.add(downItem);
            }
            int downloadItemCount = downItemList.size();
            if (downloadItemCount > 0) {
                Download[] downloadItems = downItemList.toArray(new Download[0]);
                downloadProcessor = new DownloadProcessor(downloadItems, cbHandler);
                downloadProcessor.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return downloadProcessor;
    }

    static {
        DO_NOT_VERIFY = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    public static class DownloadHandler
    extends Handler {
        public static final int MSG_SET_LENGTH = 0;
        public static final int MSG_ON_RECV = 1;
        public static final int MSG_FINISHED = 2;
        public static final int MSG_ERROR = 3;
        public static final int MSG_ABORTED = 4;
        public static final int MSG_DOWNLOADED = 5;

        public DownloadHandler() {
        }

        public DownloadHandler(Looper l) {
            super(l);
        }

        public void sendSetLength(long length) {
            this.sendMessage(this.obtainMessage(0, length));
        }

        public void sendOnRecv(long recvd) {
            this.sendMessage(this.obtainMessage(1, recvd));
        }

        public void sendFinished() {
            this.sendMessage(this.obtainMessage(2));
        }

        public void sendError(String errmsg) {
            this.sendMessage(this.obtainMessage(3, errmsg));
        }

        public void sendAborted() {
            this.sendMessage(this.obtainMessage(4));
        }

        public void sendDownloaded(Download download) {
            this.sendMessage(this.obtainMessage(5, download));
        }
    }

    public static class Download {
        public URL url;
        public boolean directory;
        public File dst;
        public String name;
        public long length;
        public int downloadType;
        public File backup;

        public Download(URL url, File dst, int downloadType) {
            Log.d((String)TAG, (String)("Download URL : " + url.toString()));
            Log.d((String)TAG, (String)("Download FILE : " + dst.getAbsolutePath()));
            this.url = url;
            this.dst = dst;
            this.downloadType = downloadType;
            String[] folderPaths = dst.getAbsolutePath().split(File.separator);
            String folderPath = "";
            int length = folderPaths.length;
            if (folderPaths.length > 0) {
                --length;
            }
            for (int i = 0; i < length; ++i) {
                folderPath = i == 0 ? folderPaths[i] : folderPath + File.separator + folderPaths[i];
            }
            File file = new File(folderPath);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(this.directory = dst.isDirectory())) {
                String[] paths = url.getPath().split(File.separator);
                int n = paths.length;
                if (n > 0) {
                    --n;
                }
                if (paths[n].length() > 0) {
                    this.name = paths[n];
                }
            }
        }

        public File getDestination() {
            File f = null;
            f = this.directory ? new File(this.dst.getAbsolutePath() + File.separator + this.name) : this.dst;
            return f;
        }

        public void abortCleanup() {
            if (this.downloadType == 1) {
                this.restore();
            } else if (this.downloadType != 2) {
                this.getDestination().delete();
            }
        }

        public void backup() {
            try {
                if (this.getDestination() != null && this.getDestination().exists()) {
                    Log.d((String)TAG, (String)("backup - file name : " + this.getDestination().getName() + ", file size : " + this.getDestination().length()));
                    this.backup = File.createTempFile(this.getDestination().getName(), ".backup");
                    Util.copy(this.getDestination(), this.backup);
                    this.backup.deleteOnExit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void restore() {
            try {
                if (this.backup != null && this.backup.exists()) {
                    Log.d((String)TAG, (String)("restore - file name : " + this.backup.getName() + ", file size : " + this.backup.length()));
                    this.getDestination().createNewFile();
                    Util.copy(this.backup, this.getDestination());
                    this.backup.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class InnerHostnameVerifier
    implements HostnameVerifier {
        private URL url;

        public InnerHostnameVerifier(URL url) {
            this.url = url;
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            if (hostname != null && hostname.equals(this.url.getHost())) {
                return true;
            }
            Log.d((String)TAG, (String)("InnerHostnameVerifier miss matching : " + hostname + ", " + this.url.getHost()));
            return false;
        }
    }
}

