/*
 * Decompiled with CFR 0.152.
 */
package com.softsecurity.mTranskey;

import com.softsecurity.mTranskey.SeedCBCJava;
import com.softsecurity.mTranskey.mTransKeyCipherData;
import java.io.Serializable;

public class Crypto {
    mTransKeyCipherData transkeyCipherData;
    private static byte[] DEFAULT_IV = new byte[]{77, 111, 98, 105, 108, 101, 84, 114, 97, 110, 115, 75, 101, 121, 49, 48};
    SeedCBCJava SeedEx;
    public static final String CIPHER_ALGORITHM_SEED = "SEED";
    static final String[] STRING_TABLE = new String[]{"abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "1234567890`-=\\[];',./", "!@#$%^&*()~_+|{}:\"<>?", "1234567890"};

    public Crypto(String algorithm) {
        this.transkeyCipherData = new mTransKeyCipherData();
        this.transkeyCipherData.algorithm = algorithm;
    }

    public Crypto() {
        this.transkeyCipherData = new mTransKeyCipherData();
        this.transkeyCipherData.algorithm = CIPHER_ALGORITHM_SEED;
    }

    public Crypto(Serializable data) throws Exception {
        if (!(data instanceof mTransKeyCipherData)) {
            throw new Exception("Invalid Data!");
        }
        this.transkeyCipherData = (mTransKeyCipherData)data;
        this.SeedEx = new SeedCBCJava();
        this.SeedEx.SeedContext_SetKey(this.transkeyCipherData.cryptKey);
    }

    public void setSecureKey(byte[] key) {
        this.transkeyCipherData.cryptKey = key;
        this.SeedEx = new SeedCBCJava();
        this.SeedEx.SeedContext_SetKey(this.transkeyCipherData.cryptKey);
    }

    public byte[] getSecureKey() {
        return this.transkeyCipherData.cryptKey;
    }

    public void generateSecureKey() {
        this.transkeyCipherData.cryptKey = new byte[16];
        int i = 0;
        while (i < 16) {
            this.transkeyCipherData.cryptKey[i] = (byte)(Math.random() * 128.0);
            ++i;
        }
        this.SeedEx = new SeedCBCJava();
        this.SeedEx.SeedContext_SetKey(this.transkeyCipherData.cryptKey);
    }

    public byte[] encryptData(byte[] data, int dataLength) {
        byte[] encryptedData = new byte[16];
        this.SeedEx.SeedContext_EncryptCbc(DEFAULT_IV, data, dataLength, encryptedData);
        return encryptedData;
    }

    public static String asHexString(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        int i = 0;
        while (i < buf.length) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
            ++i;
        }
        return strbuf.toString();
    }

    public static byte[] toByteArray(String hexStr) {
        int len = hexStr.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(hexStr.charAt(i), 16) << 4) + Character.digit(hexStr.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public String getDecryptCipherData(String hexStr) {
        if (hexStr == null || hexStr.length() < 32 || hexStr.length() % 32 != 0) {
            return "";
        }
        String plainData = "";
        byte[] cipherData = Crypto.toByteArray(hexStr);
        byte[] tmpBuf = new byte[16];
        int size = hexStr.length() / 32;
        int i = 0;
        while (i < size) {
            try {
                System.arraycopy(cipherData, i * 16, tmpBuf, 0, 16);
                byte[] tmpDecryptData = new byte[16];
                this.SeedEx.SeedContext_DecryptCbc(DEFAULT_IV, tmpBuf, 16, tmpDecryptData);
                plainData = String.valueOf(plainData) + STRING_TABLE[tmpDecryptData[0] - 1].charAt(tmpDecryptData[1] - 1);
            }
            catch (Exception e) {
                return "";
            }
            ++i;
        }
        return plainData;
    }

    public byte[] decryptData(byte[] cipherData, int realDataLength) {
        byte[] decryptedData = new byte[16];
        this.SeedEx.SeedContext_DecryptCbc(DEFAULT_IV, cipherData, realDataLength, decryptedData);
        return decryptedData;
    }

    public static String decryptSecureData(String hexSecureData) {
        if (hexSecureData == null || hexSecureData.length() < 32) {
            return "";
        }
        String strHeader = "";
        String strCipherData = "";
        byte[] bHeader = Crypto.toByteArray(hexSecureData.substring(0, 8));
        strHeader = new String(bHeader);
        if (!strHeader.equalsIgnoreCase("MTK1")) {
            System.out.println("DecryptSecureData - Not Matched Protocol Header");
            return "";
        }
        byte[] byteKey = Crypto.toByteArray(hexSecureData.substring(8, 40));
        strCipherData = hexSecureData.substring(40);
        Crypto tkc = new Crypto(CIPHER_ALGORITHM_SEED);
        tkc.setSecureKey(byteKey);
        String plainData = tkc.getDecryptCipherData(strCipherData);
        return plainData;
    }
}

