/*
 * Decompiled with CFR 0.152.
 */
package kr.co.clipsoft.eform.util;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class FileDeleteUtility {
    private String directoryPathString;
    private ArrayList<String> targetExtention = new ArrayList();

    public FileDeleteUtility(String directoryPathString) {
        this.directoryPathString = directoryPathString;
    }

    public FileDeleteUtility(String directoryPathString, ArrayList<String> targetExtention) {
        this.directoryPathString = directoryPathString;
        this.targetExtention = targetExtention;
    }

    public int deleteFilesForDaysFromToday(int day) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        calendar.setTime(date);
        calendar.add(5, -1 * day);
        String Today = String.format("%d-%d-%d 23:59:59", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        try {
            calendar.setTime(formatter.parse(Today));
        }
        catch (ParseException e1) {
            return 0;
        }
        return this.deleteFiles(calendar.getTime().getTime());
    }

    public int deleteFilesForMonthFromThisMonth(int month) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        calendar.setTime(date);
        calendar.add(2, -1 * month);
        calendar.set(5, calendar.getActualMaximum(5));
        String timeString = this.getLastDateTimeStringOfThisDate(calendar);
        try {
            calendar.setTime(formatter.parse(timeString));
        }
        catch (ParseException e1) {
            return 0;
        }
        return this.deleteFiles(calendar.getTime().getTime());
    }

    public int deleteFilesForYearFromThisYear(int year) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        calendar.setTime(date);
        calendar.add(1, -1 * year);
        calendar.set(2, calendar.getActualMaximum(2));
        calendar.set(5, calendar.getActualMaximum(5));
        String timeString = this.getLastDateTimeStringOfThisDate(calendar);
        try {
            calendar.setTime(formatter.parse(timeString));
        }
        catch (ParseException e1) {
            return 0;
        }
        return this.deleteFiles(calendar.getTime().getTime());
    }

    public int deleteFilesFromDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        calendar.setTime(date);
        String timeString = this.getLastDateTimeStringOfThisDate(calendar);
        try {
            calendar.setTime(formatter.parse(timeString));
        }
        catch (ParseException e1) {
            return 0;
        }
        return this.deleteFiles(calendar.getTime().getTime());
    }

    private int deleteFiles(long basicDateTime) {
        File[] files;
        int deleteFileCount = 0;
        File directory = new File(this.directoryPathString);
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            long lastModified = file.lastModified();
            if (lastModified <= basicDateTime && this.isTargetExtention(file.getName()) && file.delete()) {
                ++deleteFileCount;
            }
            ++n2;
        }
        return deleteFileCount;
    }

    private boolean isTargetExtention(String fileName) {
        if (this.targetExtention.size() == 0) {
            return true;
        }
        boolean result = false;
        for (String extention : this.targetExtention) {
            if (!fileName.contains(extention)) continue;
            result = true;
            break;
        }
        return result;
    }

    private String getLastDateTimeStringOfThisDate(Calendar calendar) {
        String timeString = String.format("%d-%d-%d 23:59:59", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        return timeString;
    }
}

