/*
 * Decompiled with CFR 0.152.
 */
package kr.co.clipsoft.eform;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Base64;
import android.util.Log;
import java.security.Key;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kr.co.clipsoft.eform.DuplicateCallCheck;
import kr.co.clipsoft.eform.event.Event;
import kr.co.clipsoft.eform.event.ExitEventArgs;
import kr.co.clipsoft.eform.event.IEventHandler;
import kr.co.clipsoft.eform.event.ResultEventArgs;
import kr.co.clipsoft.eform.event.ViewerActionEventArgs;
import kr.co.clipsoft.eform.information.ResultData;
import kr.co.clipsoft.eform.information.RunOption;
import kr.co.clipsoft.eform.information.StaticVariables;
import kr.co.clipsoft.eform.information.ViewerActionEventData;
import kr.co.clipsoft.eform.observer.ResultContentObserver;
import kr.co.clipsoft.eform.type.enumtype.ProcessType;
import kr.co.clipsoft.eform.type.enumtype.ProviderAction;
import kr.co.clipsoft.eform.util.FileDeleteUtility;

public class EFormToolkit {
    private static String TAG = "kr.co.clipsoft.eform.EFormToolkit";
    private Event<ResultEventArgs> _resultEvent = new Event();
    private Event<ExitEventArgs> _exitEvent = new Event();
    private Event<ViewerActionEventArgs> _viewerActionEvent = new Event();
    private Context _context;
    private Uri _contentChangeListenerUri;
    private Uri _viewerEventListenerUri;
    private Uri _contentEFormUri = Uri.parse((String)"content://kr.co.clipsoft.clipeform.data");
    private String _sessionKey = "";
    private ContentResolver _contentResolver;
    private ResultContentObserver _resultObserver;
    private ResultContentObserver _viewerActionEventObserver;
    private RunOption _runOption = null;
    private FileDeleteUtility _fileDeleteUtility;
    private long _milisecondToPreventDuplicateCalls = 3000L;
    private boolean _preventDuplicateCalls = true;
    private int _minViewerVersionCode = 428;
    private int _toolkitVersion = 428;
    private Handler _resultHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            Log.d((String)TAG, (String)"resultHandler \uc774\ubca4\ud2b8 \ubc1c\uc0dd");
            Bundle param = new Bundle();
            param.putString("sessionKey", EFormToolkit.this._sessionKey);
            Bundle result = EFormToolkit.this._contentResolver.call(EFormToolkit.this._contentEFormUri, "", ProviderAction.GET_RESULT_DATA.toString(), param);
            if (result == null || !result.containsKey("resultData")) {
                Object resultData = null;
            } else {
                ResultData resultData = (ResultData)result.get("resultData");
                switch (resultData.getResultCode()) {
                    case SAVE: 
                    case TEMP_SAVE: 
                    case TEMP_SAVE2: {
                        resultData.setDataXml(EFormToolkit.this.getDataFromViewer());
                        EFormToolkit.this._resultEvent.raiseEvent((Object)this, new ResultEventArgs(resultData));
                        break;
                    }
                    case EXIT: 
                    case ERROR_EXIT: {
                        EFormToolkit.this.removeData();
                        EFormToolkit.this.releaseObserver();
                        new EFormViewerExitCheck().execute(new ResultData[]{resultData});
                    }
                }
            }
        }
    };
    private Handler _viewerActionEventHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            Log.d((String)(String.valueOf(TAG) + " viewerActionEventHandler"), (String)"viewerEventHandler \uc774\ubca4\ud2b8 \ubc1c\uc0dd");
            Bundle param = new Bundle();
            param.putString("sessionKey", EFormToolkit.this._sessionKey);
            Bundle result = EFormToolkit.this._contentResolver.call(EFormToolkit.this._contentEFormUri, "", ProviderAction.GET_VIEWER_ACTION_EVENT_DATA.toString(), param);
            if (result == null || !result.containsKey("viewerActionEventData")) {
                Object var4_4 = null;
            }
            ViewerActionEventData viewerActionEventData = (ViewerActionEventData)result.get("viewerActionEventData");
            EFormToolkit.this._viewerActionEvent.raiseEvent((Object)this, new ViewerActionEventArgs(viewerActionEventData));
        }
    };

    public EFormToolkit(Context context) {
        this.initializeFileDeleteUtility();
        this._context = context;
        this._contentResolver = context.getContentResolver();
    }

    private void initializeFileDeleteUtility() {
        this._fileDeleteUtility = new FileDeleteUtility(StaticVariables.FORM_VIEW_WORK_TEMP_DIRECTORY);
    }

    private void setContentProviderKey() {
        this.initializeKey();
        Bundle bundle = new Bundle();
        bundle.putString("sessionKey", this._sessionKey);
        this._contentResolver.call(this._contentEFormUri, "", ProviderAction.CREATE_SESSION.toString(), bundle);
        this._contentChangeListenerUri = Uri.parse((String)("content://kr.co.clipsoft.clipeform.data/" + this._sessionKey));
        this.registerDataContentObservers();
        this._viewerEventListenerUri = Uri.parse((String)("content://kr.co.clipsoft.clipeform.data/" + ProviderAction.VIEWER_ACTION_EVENT.toString() + "/" + this._sessionKey));
        this.registerViewerActionEventObserver();
    }

    private void initializeKey() {
        this._sessionKey = UUID.randomUUID().toString().replace("-", "");
    }

    private String getDataFromViewer() {
        Bundle data = new Bundle();
        data.putString("sessionKey", this._sessionKey);
        Bundle result = this._contentResolver.call(this._contentEFormUri, "", ProviderAction.GET_DATA_LIST_COUNT.toString(), data);
        int dataListCount = result.getInt("dataListCount");
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < dataListCount) {
            data.putInt("dataListIndex", i);
            Bundle dataResult = this._contentResolver.call(this._contentEFormUri, "", ProviderAction.GET_DATA_LIST_DATA.toString(), data);
            stringBuffer.append(dataResult.getString("data"));
            ++i;
        }
        this._contentResolver.call(this._contentEFormUri, "", ProviderAction.CLEAR_DATA_LIST.toString(), data);
        String dataXml = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringBuffer = null;
        Log.d((String)(String.valueOf(TAG) + " provider"), (String)("getDataFromViewer data \uc0ac\uc774\uc988." + dataXml.length()));
        return dataXml;
    }

    private void registerDataContentObservers() {
        this.releaseDataObserver();
        this._resultObserver = new ResultContentObserver(this._resultHandler);
        this._contentResolver.registerContentObserver(this._contentChangeListenerUri, true, (ContentObserver)this._resultObserver);
    }

    private void registerViewerActionEventObserver() {
        this.releaseViewerActionEventObserver();
        this._viewerActionEventObserver = new ResultContentObserver(this._viewerActionEventHandler);
        this._contentResolver.registerContentObserver(this._viewerEventListenerUri, true, (ContentObserver)this._viewerActionEventObserver);
    }

    private void releaseViewerActionEventObserver() {
        if (this._viewerActionEventObserver != null) {
            this._contentResolver.unregisterContentObserver((ContentObserver)this._viewerActionEventObserver);
            this._viewerActionEventObserver = null;
        }
    }

    private void releaseDataObserver() {
        if (this._resultObserver != null) {
            this._contentResolver.unregisterContentObserver((ContentObserver)this._resultObserver);
            this._resultObserver = null;
        }
    }

    private void releaseObserver() {
        this.releaseDataObserver();
        this.releaseViewerActionEventObserver();
    }

    private void removeData() {
        if (!this._sessionKey.isEmpty()) {
            Bundle bundle = new Bundle();
            bundle.putString("sessionKey", this._sessionKey);
            this._contentResolver.call(this._contentEFormUri, "", ProviderAction.REMOVE_SESSION.toString(), bundle);
        }
    }

    public String startEFormViewer(String fos) {
        long startEFormViewerTime = new Date().getTime();
        Log.d((String)TAG, (String)"CLIP e-Form Viewer \ud638\ucd9c \uc2dc\uc791.");
        if (!this.isSetupEFormViewer()) {
            Log.e((String)TAG, (String)"CLIP e-Form Viewer\ub97c \uc124\uce58\ud558\uc138\uc694.");
            return "ERROR_001";
        }
        if (this._minViewerVersionCode > this.getEFormViewerVersionCode()) {
            Log.e((String)TAG, (String)"CLIP e-Form Viewer \ubc84\uc804\uc774 Toolkit\ubcf4\ub2e4 \ub0ae\uc2b5\ub2c8\ub2e4.");
            return "ERROR_002";
        }
        if (fos == null || fos.isEmpty()) {
            Log.e((String)TAG, (String)"FOS \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
            return "ERROR_003";
        }
        if (this._preventDuplicateCalls && DuplicateCallCheck.getInstance().isDuplicateCall(this._milisecondToPreventDuplicateCalls)) {
            Log.e((String)TAG, (String)("CLIP e-Form Viewer \uc9c0\uc815\ub41c \uc2dc\uac04 [" + this._milisecondToPreventDuplicateCalls + "] milisecond \uc548\uc5d0 \ub2e4\uc2dc \ud638\ucd9c\ub418\uc5c8\uc2b5\ub2c8\ub2e4."));
            return "ERROR_004";
        }
        if (!this.checkHavePermission(this._context, "android.permission.GET_TASKS")) {
            Log.e((String)TAG, (String)"GET_TASKS \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. \uad8c\ud55c\uc744 \ubd80\uc5ec\ud6c4 \ub2e4\uc2dc \uc2e4\ud589\ud574 \uc8fc\uc2ed\uc2dc\uc624.");
            return "ERROR_006";
        }
        if (this.isRunningActivity(this._context)) {
            Log.e((String)TAG, (String)"\ud604\uc7ac CLIP e-Form Viewer\uac00 \uc2e4\ud589\uc911\uc785\ub2c8\ub2e4. \ubdf0\uc5b4\ub97c \uc885\ub8cc \ud6c4 \ub2e4\uc2dc \uc2e4\ud589\ud574 \uc8fc\uc2ed\uc2dc\uc624.");
            return "ERROR_005";
        }
        this.releaseObserver();
        this.setContentProviderKey();
        if (this._runOption == null) {
            this._runOption = new RunOption();
        }
        try {
            try {
                Log.d((String)TAG, (String)"\ub7f0\uc635\uc158 \uc554\ud638\ud654 \uc2dc\uc791.");
                long time = new Date().getTime();
                String runOption = this.encodeData(this._sessionKey, this._runOption.getJson());
                Log.d((String)TAG, (String)("\ub7f0\uc635\uc158 \uc554\ud638\ud654 \ub05d. \uc554\ud638\ud654 \uc2dc\uac04 [" + (new Date().getTime() - time) + "] ms"));
                Log.d((String)TAG, (String)"FOS \uc554\ud638\ud654 \uc2dc\uc791.");
                time = new Date().getTime();
                fos = this.encodeData(this._sessionKey, fos);
                Log.d((String)TAG, (String)("FOS \uc554\ud638\ud654 \ub05d. \uc554\ud638\ud654 \uc2dc\uac04 [" + (new Date().getTime() - time) + "] ms"));
                this.sendFosToEFormViewer(fos);
                Intent intent = new Intent("kr.co.clipsoft.eform.ViewerActivity");
                intent.putExtra("eFormType", "fos");
                intent.putExtra("localOpen", false);
                intent.putExtra("RunOption", runOption);
                intent.putExtra("sessionKey", this._sessionKey);
                intent.putExtra("toolkitVersion", this._toolkitVersion);
                intent.addFlags(0x20000000);
                intent.addFlags(0x4000000);
                this._context.startActivity(intent);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"CLIP e-Form Viewer \ud638\ucd9c \uc2e4\ud328", (Throwable)e);
            }
        }
        catch (Throwable throwable) {}
        Log.d((String)TAG, (String)("CLIP e-Form Viewer \ud638\ucd9c \ub05d. \ubdf0\uc5b4 \uc2e4\ud589\uc2dc\uae4c\uc9c0 \uac78\ub9b0 \uc2dc\uac04 [" + (new Date().getTime() - startEFormViewerTime) + "] ms"));
        return "SUCCESS";
    }

    public void setRunOption(RunOption runOption) {
        this._runOption = runOption;
    }

    public void setExitEventHandler(IEventHandler<ExitEventArgs> handler) {
        this._exitEvent.removeAllEventHandler();
        this._exitEvent.addEventHandler(handler);
    }

    public void setResultEventHandler(IEventHandler<ResultEventArgs> handler) {
        this._resultEvent.removeAllEventHandler();
        this._resultEvent.addEventHandler(handler);
    }

    public void setViewerActionEventHandler(IEventHandler<ViewerActionEventArgs> handler) {
        this._viewerActionEvent.removeAllEventHandler();
        this._viewerActionEvent.addEventHandler(handler);
    }

    private void sendEFormViewerEvent(ProcessType type, String message) {
        Bundle bundle = new Bundle();
        bundle.putString("sessionKey", this._sessionKey);
        bundle.putString("processType", type.toString());
        bundle.putString("message", message);
        this._contentResolver.call(this._contentEFormUri, "", ProviderAction.SEND_EFORM.toString(), bundle);
    }

    private void sendFosToEFormViewer(String fos) {
        Log.d((String)TAG, (String)("FOS \uc804\uc1a1 \uc2dc\uc791 \ub370\uc774\ud130 \ucd1d \uae38\uc774 : \uc57d [" + fos.length() + "] byte"));
        long time = new Date().getTime();
        int limit = 400000;
        Bundle bundle = new Bundle();
        bundle.putString("sessionKey", this._sessionKey);
        this._contentResolver.call(this._contentEFormUri, "", ProviderAction.FOS_UPLOAD_START.toString(), bundle);
        while (fos.length() > 0) {
            if (fos.length() < limit) {
                limit = fos.length();
            }
            bundle.putString("fos", fos.substring(0, limit));
            this._contentResolver.call(this._contentEFormUri, "", ProviderAction.FOS_UPLOAD.toString(), bundle);
            fos = fos.substring(limit);
        }
        this._contentResolver.call(this._contentEFormUri, "", ProviderAction.FOS_UPLOAD_END.toString(), bundle);
        Log.d((String)TAG, (String)("FOS \uc804\uc1a1 \ub05d. \uc804\uc1a1 \uc2dc\uac04 [" + (new Date().getTime() - time) + "] ms"));
    }

    public void sendEFormViewerOkEvent() {
        this.sendEFormViewerEvent(ProcessType.OK, "");
    }

    public void sendEFormViewerCancelEvent(String message) {
        this.sendEFormViewerEvent(ProcessType.Cancel, message);
    }

    private boolean isSetupEFormViewer() {
        String strAppPackage = "kr.co.clipsoft.eform";
        try {
            PackageInfo pi = this._context.getPackageManager().getPackageInfo(strAppPackage, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public String getEFormViewerVersion() {
        PackageInfo packageInfo = null;
        try {
            packageInfo = this._context.getPackageManager().getPackageInfo("kr.co.clipsoft.eform", 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "\ubc84\uc804 \uc815\ubcf4\ub97c \uac00\uc838\uc624\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.";
        }
    }

    private int getEFormViewerVersionCode() {
        PackageInfo packageInfo = null;
        try {
            packageInfo = this._context.getPackageManager().getPackageInfo("kr.co.clipsoft.eform", 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int deleteTempFilesForDaysFromToday(int day) {
        return this._fileDeleteUtility.deleteFilesForDaysFromToday(day);
    }

    @SuppressLint(value={"TrulyRandom"})
    private String encodeData(String key, String data) {
        String encodeData = data;
        try {
            byte[] iv = new byte[16];
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec newKey = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)newKey, ivSpec);
            encodeData = "CPPUBLIC_" + Base64.encodeToString((byte[])cipher.doFinal(data.getBytes()), (int)0);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"encodeData Crypto Error", (Throwable)e);
        }
        return encodeData;
    }

    public void setMilisecondToPreventDuplicateCalls(long milisecondToPreventDuplicateCalls) {
        this._milisecondToPreventDuplicateCalls = milisecondToPreventDuplicateCalls;
    }

    public void setPreventDuplicateCalls(boolean preventDuplicateCalls) {
        this._preventDuplicateCalls = preventDuplicateCalls;
    }

    private boolean isRunningActivity(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List taskInfo = am.getRunningTasks(1);
        ComponentName cn = ((ActivityManager.RunningTaskInfo)taskInfo.get((int)0)).topActivity;
        return cn.getClassName().equals("kr.co.clipsoft.eform.ViewerActivity");
    }

    private boolean checkHavePermission(Context context, String permession) {
        int result = context.checkCallingOrSelfPermission(permession);
        return result == 0;
    }

    class EFormViewerExitCheck
    extends AsyncTask<ResultData, Void, Void> {
        private ResultData _resultData;

        EFormViewerExitCheck() {
        }

        protected Void doInBackground(ResultData ... params) {
            this._resultData = params[0];
            long limit = 50L;
            while (EFormToolkit.this.isRunningActivity(EFormToolkit.this._context) && limit > 0L) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                --limit;
            }
            return null;
        }

        protected void onPostExecute(Void result) {
            Log.d((String)TAG, (String)"CLIP e-Form Viewer \uac00 \uc885\ub8cc \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            EFormToolkit.this._exitEvent.raiseEvent((Object)this, new ExitEventArgs(this._resultData));
        }
    }
}

